/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.io.IOException;
import sampl.Util;
import sampl.lang.AbstractExpr;
import sampl.lang.ExprVisitor;
import sampl.lang.NLConnection;

public final class Number
extends AbstractExpr {
    private double value;
    public static final Number ZERO = new Number(0.0);

    public Number(double value) {
        this.value = value;
    }

    public static Number valueOf(double d) {
        return new Number(d);
    }

    public double value() {
        return this.value;
    }

    @Override
    public String toString() {
        return Util.format(this.value);
    }

    public boolean equals(Object obj) {
        return obj instanceof Number && Double.compare(((Number)obj).value, this.value) == 0;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public boolean hasVariables() {
        return false;
    }

    @Override
    public double eval() {
        return this.value;
    }

    @Override
    public void accept(ExprVisitor v) {
        v.visit(this);
    }

    @Override
    public void write(NLConnection c) throws IOException {
        c.writeConstant(this.value);
    }
}

