/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import sampl.Util;
import sampl.lang.Constraint;
import sampl.lang.Evaluable;
import sampl.lang.ExpandedProblem;
import sampl.lang.Expr;
import sampl.lang.LinearTerm;
import sampl.lang.Objective;
import sampl.lang.ObjectiveMap;
import sampl.lang.SolverConnection;
import sampl.lang.Variable;

final class NLConnection
extends SolverConnection {
    private Writer writer;

    private void write(String s) throws IOException {
        this.writer.append(s);
    }

    private void write(int n) throws IOException {
        this.writer.append(Integer.toString(n));
    }

    private void write(char c) throws IOException {
        this.writer.append(c);
    }

    private void write(double value) throws IOException {
        if ((double)((long)value) == value) {
            this.write(Long.toString((long)value));
        } else {
            this.write(Double.toString(value));
        }
    }

    private void writeBounds(double lower, double upper) throws IOException {
        if (lower != Double.NEGATIVE_INFINITY) {
            if (upper == Double.POSITIVE_INFINITY) {
                this.write("2 ");
                this.write(lower);
                this.write(Util.NEWLINE);
            } else if (Double.compare(lower, upper) == 0) {
                this.write("4 ");
                this.write(lower);
                this.write(Util.NEWLINE);
            } else {
                this.write("0 ");
                this.write(lower);
                this.write(' ');
                this.write(upper);
                this.write(Util.NEWLINE);
            }
        } else if (upper != Double.POSITIVE_INFINITY) {
            this.write("1 ");
            this.write(upper);
            this.write(Util.NEWLINE);
        } else {
            this.write('3');
            this.write(Util.NEWLINE);
        }
    }

    private void write(int numContinuousVars, List<LinearTerm> linear, char type, int index) throws IOException {
        if (linear == null) {
            return;
        }
        this.write(type);
        this.write(index);
        this.write(' ');
        this.write(linear.size());
        this.write(Util.NEWLINE);
        ArrayList<LinearTerm> intTerms = null;
        for (LinearTerm term : linear) {
            int varIndex = term.getVariable().index();
            if (varIndex >= numContinuousVars) {
                if (intTerms == null) {
                    intTerms = new ArrayList<LinearTerm>();
                }
                intTerms.add(term);
                continue;
            }
            this.write(varIndex);
            this.write(' ');
            this.write(term.getCoefficient());
            this.write(Util.NEWLINE);
        }
        if (intTerms == null) {
            return;
        }
        for (LinearTerm term : intTerms) {
            this.write(term.getVariable().index());
            this.write(' ');
            this.write(term.getCoefficient());
            this.write(Util.NEWLINE);
        }
    }

    void writeConstant(double value) throws IOException {
        this.write('n');
        this.write(value);
        this.write(Util.NEWLINE);
    }

    void write(Variable var) throws IOException {
        this.write('v');
        this.write(var.index());
        this.write(Util.NEWLINE);
    }

    void writeOp(int code) throws IOException {
        this.write('o');
        this.write(code);
        this.write(Util.NEWLINE);
    }

    void writeInt(int value) throws IOException {
        this.write(value);
        this.write(Util.NEWLINE);
    }

    void writeExpanded(ExpandedProblem ep, String name, Writer writer) throws IOException {
        Object nonlinear;
        Variable[] vars = ep.getVariables();
        Objective[] objs = ep.getObjectives();
        Constraint[] cons = ep.getConstraints();
        int numVars = vars.length;
        this.writer = writer;
        this.write(this.linearizedPL() ? "g8 0 1 0 6 20020528 0 4 1" : "g3 0 1 0");
        this.write("\t# problem ");
        this.write(name);
        this.write(Util.NEWLINE);
        this.write(' ');
        this.write(numVars);
        this.write(' ');
        this.write(cons.length);
        this.write(' ');
        this.write(objs.length);
        this.write(' ');
        this.write(ep.numRanges());
        this.write(' ');
        this.write(ep.numEquations());
        this.write("\t# vars, constraints, objectives, ranges, eqns");
        this.write(Util.NEWLINE);
        this.write(' ');
        this.write(ep.numNonlinearCons());
        this.write(' ');
        this.write(ep.numNonlinearObjs());
        this.write("\t# nonlinear constraints, objectives");
        this.write(Util.NEWLINE);
        this.write(" 0 0\t# network constraints: nonlinear, linear");
        this.write(Util.NEWLINE);
        this.write(' ');
        this.write(ep.numConNonlinearVars());
        this.write(' ');
        this.write(ep.numObjNonlinearVars());
        this.write(" 0\t# nonlinear vars in constraints, objectives, both");
        this.write(Util.NEWLINE);
        this.write(" 0 0 0 1\t# linear network variables; functions; arith, flags");
        this.write(Util.NEWLINE);
        this.write(' ');
        this.write(ep.numBinaries());
        this.write(' ');
        this.write(ep.numIntegers());
        this.write(" 0 0 0\t# discrete variables: binary, integer, nonlinear (b,c,o)");
        this.write(Util.NEWLINE);
        this.write(' ');
        this.write(ep.numConNonzeros());
        this.write(' ');
        this.write(ep.numObjNonzeros());
        this.write("\t# nonzeros in Jacobian, gradients");
        this.write(Util.NEWLINE);
        this.write(" 0 0\t# max name lengths: constraints, variables");
        this.write(Util.NEWLINE);
        this.write(" 0 0 0 0 0\t# common exprs: b,c,o,c1,o1");
        this.write(Util.NEWLINE);
        int i = 0;
        int n = cons.length;
        while (i < n) {
            this.write('C');
            this.write(i);
            this.write(Util.NEWLINE);
            Expr nonlinear2 = cons[i].getNonlinear();
            if (nonlinear2 != null) {
                nonlinear2.write(this);
            } else {
                this.write("n0");
                this.write(Util.NEWLINE);
            }
            ++i;
        }
        i = 0;
        n = objs.length;
        while (i < n) {
            Objective obj = objs[i];
            this.write('O');
            this.write(i);
            this.write(' ');
            this.write(((ObjectiveMap)obj.map()).isMaximization() ? 1 : 0);
            this.write(Util.NEWLINE);
            nonlinear = obj.getNonlinear();
            if (nonlinear != null) {
                nonlinear.write(this);
            } else {
                this.writeConstant(obj.constant());
            }
            ++i;
        }
        if (cons.length != 0) {
            this.write('r');
            this.write(Util.NEWLINE);
            nonlinear = cons;
            int obj = cons.length;
            n = 0;
            while (n < obj) {
                Evaluable con = nonlinear[n];
                this.writeBounds(((Constraint)con).lb(), ((Constraint)con).ub());
                ++n;
            }
        }
        this.write('b');
        this.write(Util.NEWLINE);
        nonlinear = vars;
        int obj = vars.length;
        n = 0;
        while (n < obj) {
            Evaluable var = nonlinear[n];
            this.writeBounds(((Variable)var).lb(), ((Variable)var).ub());
            ++n;
        }
        this.write('k');
        this.write(numVars - 1);
        this.write(Util.NEWLINE);
        int cumulativeCount = 0;
        int[] numVarLinearTerms = ep.numVarLinearTerms();
        int i2 = 0;
        int n2 = numVars - 1;
        while (i2 < n2) {
            this.write(cumulativeCount += numVarLinearTerms[i2]);
            this.write(Util.NEWLINE);
            ++i2;
        }
        int numContinuousVars = numVars - ep.numBinaries() - ep.numIntegers();
        int i3 = 0;
        int n3 = cons.length;
        while (i3 < n3) {
            this.write(numContinuousVars, cons[i3].getLinear(), 'J', i3);
            ++i3;
        }
        i3 = 0;
        n3 = objs.length;
        while (i3 < n3) {
            this.write(numContinuousVars, objs[i3].getLinear(), 'G', i3);
            ++i3;
        }
    }

    public NLConnection() {
    }

    public NLConnection(Writer w) {
        this.writer = w;
    }

    @Override
    public void writeExpanded(ExpandedProblem ep, SolverConnection.WriterProvider wp) throws IOException {
        Writer writer = wp.newWriter(".nl");
        try {
            this.writeExpanded(ep, wp.filenameWithoutExt(), writer);
        }
        finally {
            writer.close();
        }
    }
}

