/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import sampl.Tuple;
import sampl.lang.Entity;
import sampl.lang.SAMPL;

abstract class MapItem<T extends Entity<?>> {
    private T map;
    private Object key;

    MapItem(T map, Object key) {
        if (map == null) {
            throw new NullPointerException("map is null");
        }
        this.map = map;
        this.key = key;
    }

    public T map() {
        return this.map;
    }

    static String name(Entity<?> entity, Object key, int scenarioIndex) {
        if (key == null) {
            return entity.name();
        }
        StringBuilder sb = new StringBuilder(entity.name());
        sb.append('[');
        if (key instanceof Tuple) {
            Tuple tuple = (Tuple)key;
            sb.append(scenarioIndex != 0 ? SAMPL.formatKey(tuple.get(0)) : "?");
            int i = 1;
            int n = tuple.size();
            while (i < n) {
                sb.append(',');
                sb.append(scenarioIndex != i ? SAMPL.formatKey(tuple.get(i)) : "?");
                ++i;
            }
        } else {
            sb.append(scenarioIndex != 0 ? SAMPL.formatKey(key) : "?");
        }
        sb.append(']');
        return sb.toString();
    }

    static String name(Entity<?> entity, Object key) {
        return MapItem.name(entity, key, -1);
    }

    public String name() {
        return MapItem.name(this.map, this.key);
    }
}

