/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sampl.lang.Variable;

public final class LinearTerm
implements Comparable<LinearTerm> {
    private double coefficient;
    private Variable variable;

    public LinearTerm(double coef, Variable var) {
        this.coefficient = coef;
        this.variable = var;
    }

    public double getCoefficient() {
        return this.coefficient;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public static List<LinearTerm> combineLikeTerms(List<LinearTerm> linear) {
        Collections.sort(linear);
        int size = linear.size();
        ArrayList<LinearTerm> combined = new ArrayList<LinearTerm>(size);
        LinearTerm last = linear.get(0);
        combined.add(last);
        int i = 1;
        while (i < size) {
            LinearTerm term = linear.get(i);
            if (last.variable != term.variable) {
                combined.add(term);
                last = term;
            } else {
                double coef = term.coefficient + last.coefficient;
                last = new LinearTerm(coef, term.variable);
                combined.set(combined.size() - 1, last);
            }
            ++i;
        }
        return combined;
    }

    public String toString() {
        if (this.coefficient == 1.0) {
            return this.variable.toString();
        }
        if (this.coefficient == -1.0) {
            return "-" + this.variable;
        }
        return String.valueOf(this.coefficient) + " * " + this.variable;
    }

    @Override
    public int compareTo(LinearTerm lt) {
        return this.variable.index() - lt.variable.index();
    }
}

