/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import sampl.Util;
import sampl.lang.BinaryExpr;
import sampl.lang.CallExpr;
import sampl.lang.DiscreteRV;
import sampl.lang.Expr;
import sampl.lang.ExprVisitor;
import sampl.lang.LinearTerm;
import sampl.lang.Number;
import sampl.lang.PiecewiseLinear;
import sampl.lang.SymmetricRV;
import sampl.lang.Variable;
import sampl.lang.WeightedSum;

class ExprPrinter
implements ExprVisitor {
    private Writer writer;
    private int precedence;

    private static void printCoef(Writer out, double coef, boolean first) {
        try {
            if (coef < 0.0) {
                out.write(first ? "-" : " - ");
                coef = -coef;
            } else if (!first) {
                out.write(" + ");
            }
            if (coef != 1.0) {
                out.write(Util.format(coef));
                out.write("*");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void print(Writer out, Expr nonlinear, List<LinearTerm> linear, double constant) throws IOException {
        FixedPrinter printer = new FixedPrinter(out);
        if (nonlinear != null) {
            printer.print(nonlinear);
        }
        if (linear != null) {
            boolean first = nonlinear == null;
            int i = 0;
            int n = linear.size();
            while (i != n) {
                LinearTerm term = linear.get(i);
                ExprPrinter.printCoef(out, term.getCoefficient(), first);
                out.write(term.getVariable().name());
                first = false;
                ++i;
            }
        }
        if (linear == null && nonlinear == null) {
            printer.print(Util.format(constant));
        } else if (Double.compare(constant, 0.0) != 0) {
            printer.print(" + ");
            printer.print(Util.format(constant));
        }
    }

    private void printTerm(WeightedSum expr, int index) {
        ExprPrinter.printCoef(this.writer, expr.getWeight(index), index == 0);
        expr.getExpr(index).accept(this);
    }

    private void write(String s) {
        try {
            this.writer.append(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void write(double d) {
        this.write(Util.format(d));
    }

    private int enter(int newPrecedence) {
        int savedPrecedence = this.precedence;
        if (savedPrecedence > newPrecedence) {
            this.write("(");
        }
        this.precedence = newPrecedence;
        return savedPrecedence;
    }

    private void leave(int savedPrecedence) {
        if (savedPrecedence > this.precedence) {
            this.write(")");
        }
        this.precedence = savedPrecedence;
    }

    ExprPrinter(Writer w) {
        this.writer = w;
    }

    @Override
    public void visit(Number num) {
        this.write(num.toString());
    }

    @Override
    public void visit(Variable var) {
        this.write(var.name());
    }

    @Override
    public void visit(BinaryExpr expr) {
        int savedPrecedence = this.enter(expr.precedence());
        expr.getLHS().accept(this);
        this.write(expr.getOpStr());
        expr.getRHS().accept(this);
        this.leave(savedPrecedence);
    }

    @Override
    public void visit(WeightedSum expr) {
        int savedPrecedence = this.enter(11);
        this.printTerm(expr, 0);
        int i = 1;
        int n = expr.size();
        while (i < n) {
            this.printTerm(expr, i);
            ++i;
        }
        this.leave(savedPrecedence);
    }

    @Override
    public void visit(PiecewiseLinear pl) {
        this.write("<<");
        int numSlopes = pl.getNumSlopes();
        this.write(pl.getBreakpoint(0));
        int i = 1;
        int n = numSlopes - 1;
        while (i < n) {
            this.write(", ");
            this.write(pl.getBreakpoint(i));
            ++i;
        }
        this.write("; ");
        this.write(pl.getSlope(0));
        i = 1;
        while (i < numSlopes) {
            this.write(", ");
            this.write(pl.getSlope(i));
            ++i;
        }
        this.write(">> ");
        this.visit(pl.getVariable());
    }

    @Override
    public void visit(CallExpr expr) {
        this.write("probability(");
        expr.arg().accept(this);
        this.write(")");
    }

    @Override
    public void visit(DiscreteRV rv) {
        this.write("random(");
        int numRealizations = rv.numRealizations();
        if (numRealizations != 0) {
            this.write(rv.getRealization(0));
            int i = 1;
            while (i < numRealizations) {
                this.write(", ");
                this.write(rv.getRealization(i));
                ++i;
            }
        }
        this.write(")");
    }

    @Override
    public void visit(SymmetricRV rv) {
        this.write("symmetric(");
        this.write(rv.lb());
        this.write(", ");
        this.write(rv.ub());
        this.write(")");
    }

    private static class FixedPrinter {
        private Writer writer;
        private int lineLength;

        FixedPrinter(Writer w) {
            this.writer = w;
        }

        void print(Object o) throws IOException {
            String s = o.toString();
            int newLength = this.lineLength + s.length();
            if (newLength >= 72 && this.lineLength != 0) {
                this.writer.write(Util.NEWLINE);
                this.writer.write(9);
                newLength = s.length();
            }
            this.writer.write(s);
            this.lineLength = newLength;
        }
    }
}

