/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sampl.Integrality;
import sampl.lang.AbstractExprVisitor;
import sampl.lang.Constraint;
import sampl.lang.ConstraintMap;
import sampl.lang.Expr;
import sampl.lang.LinearTerm;
import sampl.lang.Objective;
import sampl.lang.Problem;
import sampl.lang.ProblemMap;
import sampl.lang.Variable;
import sampl.lang.VariableMap;

class ExpandedProblem {
    private Variable[] vars;
    private Objective[] objs;
    private Constraint[] cons;
    private int[] numVarLinearTerms;
    private int numBinaries;
    private int numIntegers;
    private int numRanges;
    private int numEquations;
    private int numNonlinearVars;
    private int numNonlinearCons;
    private int numNonlinearObjs;
    private int numConNonzeros;
    private int numObjNonzeros;
    private int numConNonlinearVars;
    private int numObjNonlinearVars;
    private static final int PERMUTE_CONS = 1;
    private static final int PERMUTE_VARS = 2;

    private static int copy(VariableMap from, Variable[] to, int startIndex) {
        for (Map.Entry entry : from.entrySet()) {
            Variable v = (Variable)entry.getValue();
            v.setIndex(startIndex);
            to[startIndex++] = v;
        }
        return startIndex;
    }

    private void extractInfo(ConstraintMap map, NonlinearVariableCounter nvc) {
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            Expr nonlinear;
            Constraint con = (Constraint)entry.getValue();
            List linear = con.getLinear();
            if (linear != null) {
                this.numConNonzeros += linear.size();
                for (LinearTerm term : linear) {
                    Variable var = term.getVariable();
                    int n = var.index();
                    this.numVarLinearTerms[n] = this.numVarLinearTerms[n] + 1;
                }
            }
            if ((nonlinear = con.getNonlinear()) != null) {
                ++this.numNonlinearCons;
                nonlinear.accept(nvc);
            }
            if (Double.compare(con.lb(), con.ub()) == 0) {
                ++this.numEquations;
                continue;
            }
            if (con.lb() == Double.NEGATIVE_INFINITY || con.ub() == Double.POSITIVE_INFINITY) continue;
            ++this.numRanges;
        }
    }

    ExpandedProblem(Problem p, VariableMap auxVars, ConstraintMap auxCons, boolean preserveOrder) {
        Problem.Instance pi = p.expand();
        List<Variable> unorderedVars = pi.variables();
        int numVars = unorderedVars.size() + auxVars.size();
        this.vars = new Variable[numVars];
        ProblemMap map = (ProblemMap)p.map();
        if (!preserveOrder && !map.getBooleanOption("relax_integrality") && (map.getIntOption("nl_permute") & 2) != 0) {
            int varIndex = 0;
            for (Variable v : unorderedVars) {
                Object type = v.map().getType();
                if (type == Integrality.CONTINUOUS) {
                    v.setIndex(varIndex);
                    this.vars[varIndex++] = v;
                    continue;
                }
                if (type == Integrality.BINARY) {
                    ++this.numBinaries;
                    continue;
                }
                ++this.numIntegers;
            }
            varIndex = ExpandedProblem.copy(auxVars, this.vars, varIndex);
            if (this.numBinaries != 0 || this.numIntegers != 0) {
                int binIndex = varIndex + this.numIntegers;
                for (Variable v : unorderedVars) {
                    Integrality type = v.map().getType();
                    if (type == Integrality.CONTINUOUS) continue;
                    if (type == Integrality.BINARY) {
                        v.setIndex(binIndex);
                        this.vars[binIndex++] = v;
                        continue;
                    }
                    v.setIndex(varIndex);
                    this.vars[varIndex++] = v;
                }
            }
        } else {
            this.vars = unorderedVars.toArray(this.vars);
            ExpandedProblem.copy(auxVars, this.vars, unorderedVars.size());
        }
        this.numVarLinearTerms = new int[numVars];
        NonlinearVariableCounter nvc = new NonlinearVariableCounter(numVars);
        List<Objective> objList = pi.objectives();
        for (Objective obj : objList) {
            List linear;
            Expr nonlinear = obj.getNonlinear();
            if (nonlinear != null) {
                ++this.numNonlinearObjs;
                nonlinear.accept(nvc);
            }
            if ((linear = obj.getLinear()) == null) continue;
            this.numObjNonzeros += linear.size();
        }
        this.objs = objList.toArray(new Objective[objList.size()]);
        this.numObjNonlinearVars = nvc.numNonlinearVars();
        for (ConstraintMap cons : p.constraints()) {
            this.extractInfo(cons, nvc);
        }
        this.extractInfo(auxCons, nvc);
        List<Constraint> unorderedCons = pi.constraints();
        this.cons = new Constraint[unorderedCons.size() + auxCons.size()];
        if (!preserveOrder && this.numNonlinearCons != 0 && (map.getIntOption("nl_permute") & 1) != 0) {
            int nlIndex = 0;
            int linearIndex = this.numNonlinearCons;
            Iterator<Object> iterator = unorderedCons.iterator();
            while (iterator.hasNext()) {
                Constraint con;
                this.cons[(con = iterator.next()).isNonlinear() ? nlIndex++ : linearIndex++] = con;
            }
            iterator = auxCons.entrySet().iterator();
            while (iterator.hasNext()) {
                Constraint con;
                this.cons[(con = (Constraint)(entry = (Map.Entry)iterator.next()).getValue()).isNonlinear() ? nlIndex++ : linearIndex++] = con;
            }
        } else {
            unorderedCons.toArray(this.cons);
            int conIndex = unorderedCons.size();
            for (Map.Entry entry : auxCons.entrySet()) {
                this.cons[conIndex++] = (Constraint)entry.getValue();
            }
        }
        this.numNonlinearVars = nvc.numNonlinearVars();
        this.numConNonlinearVars = this.numNonlinearVars - this.numObjNonlinearVars;
    }

    Variable[] getVariables() {
        return this.vars;
    }

    Objective[] getObjectives() {
        return this.objs;
    }

    Constraint[] getConstraints() {
        return this.cons;
    }

    int[] numVarLinearTerms() {
        return this.numVarLinearTerms;
    }

    int numBinaries() {
        return this.numBinaries;
    }

    int numIntegers() {
        return this.numIntegers;
    }

    int numRanges() {
        return this.numRanges;
    }

    int numEquations() {
        return this.numEquations;
    }

    int numNonlinearVars() {
        return this.numNonlinearVars;
    }

    int numNonlinearCons() {
        return this.numNonlinearCons;
    }

    int numNonlinearObjs() {
        return this.numNonlinearObjs;
    }

    int numConNonzeros() {
        return this.numConNonzeros;
    }

    int numObjNonzeros() {
        return this.numObjNonzeros;
    }

    int numConNonlinearVars() {
        return this.numConNonlinearVars;
    }

    int numObjNonlinearVars() {
        return this.numObjNonlinearVars;
    }

    private static class NonlinearVariableCounter
    extends AbstractExprVisitor {
        private BitSet varUsed;
        private int numNonlinearVars;

        NonlinearVariableCounter(int numVars) {
            this.varUsed = new BitSet(numVars);
        }

        int numNonlinearVars() {
            return this.numNonlinearVars;
        }

        @Override
        public void visit(Variable var) {
            int index = var.index();
            if (!this.varUsed.get(index)) {
                this.varUsed.set(index);
                ++this.numNonlinearVars;
            }
        }
    }
}

