/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.util.Map;
import sampl.lang.AbstractExpr;
import sampl.lang.ExprVisitor;
import sampl.lang.NLConnection;
import sampl.lang.NoDataException;
import sampl.lang.Parameter;

public final class DiscreteRV
extends AbstractExpr {
    private double[] realizations;

    public DiscreteRV(double ... realizations) {
        this.realizations = realizations;
    }

    public int numRealizations() {
        return this.realizations.length;
    }

    public double getRealization(int index) {
        return this.realizations[index];
    }

    public DiscreteRV addScaled(double coefficient, DiscreteRV other) {
        double[] otherRealizations = other.realizations;
        int numRealizations = this.realizations.length;
        double[] resultRealizations = new double[numRealizations];
        int i = 0;
        while (i < numRealizations) {
            resultRealizations[i] = this.realizations[i] + coefficient * otherRealizations[i];
            ++i;
        }
        return new DiscreteRV(resultRealizations);
    }

    public DiscreteRV mul(DiscreteRV other) {
        double[] otherRealizations = other.realizations;
        int numRealizations = this.realizations.length;
        double[] resultRealizations = new double[numRealizations];
        int i = 0;
        while (i < numRealizations) {
            resultRealizations[i] = this.realizations[i] * otherRealizations[i];
            ++i;
        }
        return new DiscreteRV(resultRealizations);
    }

    public DiscreteRV add(double other) {
        int numRealizations = this.realizations.length;
        double[] resultRealizations = new double[numRealizations];
        int i = 0;
        while (i < numRealizations) {
            resultRealizations[i] = this.realizations[i] + other;
            ++i;
        }
        return new DiscreteRV(resultRealizations);
    }

    public void mulAssign(DiscreteRV other) {
        double[] otherRealizations = other.realizations;
        int i = 0;
        int n = this.realizations.length;
        while (i < n) {
            int n2 = i;
            this.realizations[n2] = this.realizations[n2] * otherRealizations[i];
            ++i;
        }
    }

    public void mulAssign(double d) {
        int i = 0;
        int n = this.realizations.length;
        while (i < n) {
            int n2 = i++;
            this.realizations[n2] = this.realizations[n2] * d;
        }
    }

    public double computeExpectation(Parameter probabilities) throws NoDataException {
        int i = 0;
        double result = 0.0;
        for (Map.Entry entry : probabilities.entrySet()) {
            Double value = (Double)entry.getValue();
            if (value == null) {
                throw new NoDataException(probabilities, entry.getKey());
            }
            result += value * this.realizations[i++];
        }
        return result;
    }

    @Override
    public boolean hasVariables() {
        return false;
    }

    @Override
    public double eval() {
        throw new AssertionError((Object)"Random parameter can't be evaluated as a number");
    }

    public DiscreteRV mul(double d) {
        int numRealizations = this.realizations.length;
        double[] resultRealizations = new double[numRealizations];
        int i = 0;
        while (i < numRealizations) {
            resultRealizations[i] = d * this.realizations[i];
            ++i;
        }
        return new DiscreteRV(resultRealizations);
    }

    @Override
    public void accept(ExprVisitor v) {
        v.visit(this);
    }

    @Override
    public void write(NLConnection c) {
        throw new AssertionError((Object)".nl format doesn't support random parameters");
    }
}

