/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.io.IOException;
import java.io.Writer;
import sampl.SAMPLException;
import sampl.Util;
import sampl.lang.Constraint;
import sampl.lang.Entity;
import sampl.lang.NoDataException;
import sampl.lang.SAMPL;

public class ConstraintMap
extends Entity<Constraint> {
    private boolean expanded;
    private boolean robust;

    protected void doExpand() {
    }

    public ConstraintMap(SAMPL sampl, String name, boolean robust) {
        super(sampl, name);
        this.robust = robust;
    }

    public Constraint addConstraint(Object key, double dinit) {
        Constraint c = new Constraint(this, key, dinit);
        this.map.put(key, c);
        return c;
    }

    public static Constraint newConstraint(SAMPL sampl, String name, double dinit) {
        return new ConstraintMap(sampl, name, false).addConstraint(null, dinit);
    }

    public boolean isRobust() {
        return this.robust;
    }

    public final double getValue(Object key) {
        this.update();
        return ((Constraint)this.map.get(key)).dual();
    }

    final void expand() {
        if (this.expanded) {
            return;
        }
        this.doExpand();
        this.expanded = true;
    }

    @Override
    public Constraint get(Object key) throws SAMPLException {
        Constraint value;
        if (!this.isValid()) {
            this.update();
            this.sampl().problem.expand();
        }
        if ((value = (Constraint)this.map.get(key)) != null) {
            return value;
        }
        throw new NoDataException(this, key, true);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.expanded = false;
    }

    public void expand(Writer writer) throws IOException {
        this.sampl().problem.expand();
        for (Constraint c : this.map.values()) {
            c.expand(writer);
            writer.write(Util.NEWLINE);
        }
    }
}

