/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.io.IOException;
import sampl.lang.AbstractExpr;
import sampl.lang.BinaryOp;
import sampl.lang.Expr;
import sampl.lang.ExprVisitor;
import sampl.lang.NLConnection;
import sampl.lang.Number;

public final class BinaryExpr
extends AbstractExpr {
    private BinaryOp op;
    private Expr lhs;
    private Expr rhs;

    int precedence() {
        return this.op.precedence();
    }

    String getOpStr() {
        return this.op.toString();
    }

    public BinaryExpr(BinaryOp op, Expr lhs, Expr rhs) {
        this.op = op;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public int getOpCode() {
        return this.op.opcode();
    }

    public Expr getLHS() {
        return this.lhs;
    }

    public Expr getRHS() {
        return this.rhs;
    }

    @Override
    public double eval() {
        return this.op.apply(this.lhs.eval(), this.rhs.eval());
    }

    @Override
    public boolean hasVariables() {
        return this.lhs.hasVariables() || this.rhs.hasVariables();
    }

    @Override
    public void accept(ExprVisitor v) {
        v.visit(this);
    }

    @Override
    public void write(NLConnection c) throws IOException {
        c.writeOp(this.op.opcode());
        this.lhs.write(c);
        this.rhs.write(c);
    }

    public static Expr less(Expr a, Expr b) {
        return new BinaryExpr(BinaryOp.LESS, a, b);
    }

    public static Expr mul(Expr expr, double num) {
        return new BinaryExpr(BinaryOp.MUL, expr, new Number(num));
    }

    public static Expr mul(double num, Expr expr) {
        return new BinaryExpr(BinaryOp.MUL, expr, new Number(num));
    }

    public static Expr mul(Expr a, Expr b) {
        return new BinaryExpr(BinaryOp.MUL, a, b);
    }

    public static Expr div(Expr e, double num) {
        return new BinaryExpr(BinaryOp.MUL, new Number(1.0 / num), e);
    }

    public static Expr div(double num, Expr e) {
        return new BinaryExpr(BinaryOp.DIV, new Number(num), e);
    }

    public static Expr div(Expr a, Expr b) {
        return new BinaryExpr(BinaryOp.DIV, a, b);
    }

    public static Expr pow(Expr e, double num) {
        return new BinaryExpr(BinaryOp.POW, e, new Number(num));
    }

    public static Expr le(Expr a, Expr b) {
        return new BinaryExpr(BinaryOp.LE, a, b);
    }

    public static Expr le(Expr e, double num) {
        return new BinaryExpr(BinaryOp.LE, e, new Number(num));
    }

    public static Expr ge(Expr a, Expr b) {
        return new BinaryExpr(BinaryOp.GE, a, b);
    }

    public static Expr ge(Expr e, double num) {
        return new BinaryExpr(BinaryOp.GE, e, new Number(num));
    }
}

