/*
 * Decompiled with CFR 0.152.
 */
package sampl.lang;

import java.util.List;
import sampl.lang.BinaryExpr;
import sampl.lang.BinaryOp;
import sampl.lang.Constraint;
import sampl.lang.ExprBuilder;
import sampl.lang.Number;
import sampl.lang.ProblemExpander;
import sampl.lang.RobustConverter;
import sampl.lang.Variable;

final class BenTalNemirovskiConverter
extends RobustConverter {
    BenTalNemirovskiConverter(ProblemExpander pe) {
        super(pe);
    }

    private Variable buildSOCPConstraint(List<RobustConverter.UncertainTerm> terms, double robustness) {
        Constraint socp = this.addConstraint(Double.NEGATIVE_INFINITY, 0.0);
        ExprBuilder eb = new ExprBuilder();
        for (RobustConverter.UncertainTerm term : terms) {
            BinaryExpr mul = new BinaryExpr(BinaryOp.MUL, new Number(term.coeff.getDeviation()), term.var);
            eb.add(1.0, new BinaryExpr(BinaryOp.POW, mul, new Number(2.0)));
        }
        Variable u = this.addVariable(0.0, Double.POSITIVE_INFINITY);
        BinaryExpr mul = new BinaryExpr(BinaryOp.MUL, new Number(1.0 / robustness), u);
        eb.add(-1.0, new BinaryExpr(BinaryOp.POW, mul, new Number(2.0)));
        socp.setNonlinear(eb.toExpr());
        return u;
    }

    @Override
    void convert(Constraint con, List<RobustConverter.UncertainTerm> terms) {
        double robustness = con.robustness();
        double lb = con.lb();
        double ub = con.ub();
        if (ub != Double.POSITIVE_INFINITY) {
            if (lb == Double.NEGATIVE_INFINITY) {
                con.addTerm(1.0, this.buildSOCPConstraint(terms, robustness));
                con.setLB(ub);
            } else {
                Variable rangeVar = this.convertRangeConstraint(con);
                Constraint auxCon = this.addConstraint(ub, ub);
                auxCon.addTerm(1.0, rangeVar);
                auxCon.addTerm(1.0, this.buildSOCPConstraint(terms, robustness));
                auxCon = this.addConstraint(lb, lb);
                auxCon.addTerm(1.0, rangeVar);
                auxCon.addTerm(-1.0, this.buildSOCPConstraint(terms, robustness));
            }
        } else if (lb != Double.NEGATIVE_INFINITY) {
            con.addTerm(-1.0, this.buildSOCPConstraint(terms, robustness));
            con.setUB(lb);
        }
    }
}

