/*
 * Decompiled with CFR 0.152.
 */
package sampl.codegen;

import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import sampl.ast.BinaryExpr;
import sampl.ast.Expr;
import sampl.ast.IndexDef;
import sampl.ast.Indexing;
import sampl.ast.ParenExpr;
import sampl.codegen.MethodEmitter;
import sampl.types.SetType;
import sampl.types.Types;

final class IndexingCompiler {
    private MethodEmitter emitter;
    private List<Expr> parts;
    private Expr condition;
    private int dimension;
    private Label[] bodies;
    private Label[] checks;
    private int[] iterators;
    private int keyBuilderVar;
    private int keyVar;
    private int scenarioPartIndex = -1;

    IndexingCompiler(MethodEmitter emitter, Indexing indexing, boolean skipScenarioSet) {
        this.emitter = emitter;
        this.parts = indexing.getParts();
        this.condition = indexing.getCondition();
        this.dimension = indexing.getDimension();
        if (skipScenarioSet) {
            this.scenarioPartIndex = indexing.getScenarioPartIndex();
        }
    }

    IndexingCompiler(MethodEmitter emitter, Indexing indexing) {
        this(emitter, indexing, false);
    }

    IndexingCompiler(MethodEmitter emitter, List<Expr> parts) {
        this.emitter = emitter;
        this.parts = parts;
        this.dimension = parts.size();
    }

    int getKeyVar() {
        if (this.keyVar == 0) {
            MethodVisitor mv = this.emitter.getMethodVisitor();
            this.keyVar = this.emitter.getVarIndex();
            mv.visitTypeInsn(187, "sampl/Tuple");
            mv.visitInsn(89);
            mv.visitVarInsn(25, this.keyBuilderVar);
            mv.visitMethodInsn(183, "sampl/Tuple", "<init>", "([Ljava/lang/Object;)V");
            mv.visitVarInsn(58, this.keyVar);
        }
        return this.keyVar;
    }

    Label getCheckLabel() {
        return this.checks[this.checks.length - 1];
    }

    void start() {
        int numParts = this.parts.size();
        this.checks = new Label[numParts];
        this.bodies = new Label[numParts];
        this.iterators = new int[numParts];
        MethodVisitor mv = this.emitter.getMethodVisitor();
        int partialKey = 0;
        if (numParts != 1) {
            this.keyBuilderVar = this.emitter.getVarIndex();
            partialKey = this.emitter.getVarIndex();
            mv.visitIntInsn(16, this.dimension);
            mv.visitTypeInsn(189, "java/lang/Object");
            mv.visitVarInsn(58, this.keyBuilderVar);
        } else {
            this.keyVar = this.emitter.getVarIndex();
        }
        int i = 0;
        int partOffset = 0;
        while (i < numParts) {
            int partDimension;
            Expr part = this.parts.get(i);
            int[] dummyIndices = null;
            if (part.getType() instanceof SetType) {
                partDimension = part.getDimension();
                if (i == this.scenarioPartIndex) {
                    mv.visitFieldInsn(178, "sampl/lang/SAMPL", "SCENARIO_SET", "Ljava/util/Set;");
                } else {
                    this.emitter.emit(part);
                }
            } else {
                BinaryExpr binary = (BinaryExpr)part;
                assert (binary.getKind() == BinaryExpr.Kind.IN || binary.getKind() == BinaryExpr.Kind.TILDE);
                if (i == this.scenarioPartIndex) {
                    mv.visitFieldInsn(178, "sampl/lang/SAMPL", "SCENARIO_SET", "Ljava/util/Set;");
                } else {
                    this.emitter.emit(binary.getRHS());
                }
                Expr lhs = binary.getLHS();
                partDimension = binary.getDimension();
                if (lhs instanceof IndexDef) {
                    dummyIndices = new int[]{this.emitter.getVarIndex()};
                    ((IndexDef)lhs).setVarIndex(dummyIndices[0]);
                } else {
                    ParenExpr tuple = (ParenExpr)lhs;
                    int numItems = tuple.getNumItems();
                    dummyIndices = new int[numItems];
                    int j = 0;
                    while (j < numItems) {
                        Expr item = tuple.getItem(j);
                        dummyIndices[j] = this.emitter.getVarIndex();
                        if (item instanceof IndexDef) {
                            ((IndexDef)item).setVarIndex(dummyIndices[j]);
                        } else {
                            this.emitter.emit(item);
                            if (item.getType() == Types.NUMERIC) {
                                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                            }
                            mv.visitVarInsn(58, dummyIndices[j]);
                            dummyIndices[j] = -dummyIndices[j];
                        }
                        ++j;
                    }
                }
            }
            mv.visitMethodInsn(185, "java/util/Set", "iterator", "()Ljava/util/Iterator;");
            this.iterators[i] = this.emitter.getVarIndex();
            mv.visitVarInsn(58, this.iterators[i]);
            this.checks[i] = new Label();
            mv.visitJumpInsn(167, this.checks[i]);
            this.bodies[i] = new Label();
            mv.visitLabel(this.bodies[i]);
            mv.visitVarInsn(25, this.iterators[i]);
            mv.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;");
            boolean cast = false;
            if (dummyIndices != null) {
                if (dummyIndices.length != 1) {
                    mv.visitTypeInsn(192, "sampl/Tuple");
                    cast = true;
                    int j = 0;
                    while (j < dummyIndices.length) {
                        mv.visitInsn(89);
                        mv.visitIntInsn(16, j);
                        mv.visitMethodInsn(182, "sampl/Tuple", "get", "(I)Ljava/lang/Object;");
                        if (dummyIndices[j] > 0) {
                            mv.visitVarInsn(58, dummyIndices[j]);
                        } else {
                            mv.visitVarInsn(25, -dummyIndices[j]);
                            mv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
                            Label endCheck = new Label();
                            mv.visitJumpInsn(154, endCheck);
                            mv.visitInsn(87);
                            mv.visitJumpInsn(167, this.checks[i]);
                            mv.visitLabel(endCheck);
                        }
                        ++j;
                    }
                } else {
                    mv.visitInsn(89);
                    mv.visitVarInsn(58, dummyIndices[0]);
                }
            }
            if (numParts == 1) {
                mv.visitVarInsn(58, this.keyVar);
                break;
            }
            if (partDimension == 1) {
                mv.visitVarInsn(58, partialKey);
                mv.visitVarInsn(25, this.keyBuilderVar);
                mv.visitIntInsn(16, partOffset);
                mv.visitVarInsn(25, partialKey);
                mv.visitInsn(83);
            } else {
                if (!cast) {
                    mv.visitTypeInsn(192, "sampl/Tuple");
                }
                mv.visitVarInsn(25, this.keyBuilderVar);
                mv.visitIntInsn(16, partOffset);
                mv.visitMethodInsn(182, "sampl/Tuple", "insert", "([Ljava/lang/Object;I)V");
            }
            partOffset += partDimension;
            ++i;
        }
        if (this.condition != null) {
            this.emitter.emitLogical(this.condition);
            mv.visitJumpInsn(153, this.getCheckLabel());
        }
    }

    void end() {
        MethodVisitor mv = this.emitter.getMethodVisitor();
        int i = this.parts.size() - 1;
        while (i >= 0) {
            mv.visitLabel(this.checks[i]);
            mv.visitVarInsn(25, this.iterators[i]);
            mv.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z");
            mv.visitJumpInsn(154, this.bodies[i]);
            --i;
        }
    }
}

