/*
 * Decompiled with CFR 0.152.
 */
package sampl.codegen;

import org.objectweb.asm.MethodVisitor;
import sampl.ast.BinaryExpr;
import sampl.ast.ConstraintDecl;
import sampl.ast.Decl;
import sampl.ast.DoubleInequalityExpr;
import sampl.ast.Expr;
import sampl.ast.Indexing;
import sampl.ast.Suffix;
import sampl.ast.SuffixAttr;
import sampl.codegen.AbstractASTCompiler;
import sampl.codegen.DeclCompiler;
import sampl.codegen.IndexingCompiler;
import sampl.codegen.MethodEmitter;
import sampl.types.Types;

final class ConstraintDeclCompiler
extends DeclCompiler {
    private ConstraintDecl decl;
    private SuffixAttr robustness;

    ConstraintDeclCompiler(AbstractASTCompiler ce, ConstraintDecl decl) {
        super(ce, true);
        this.decl = decl;
    }

    @Override
    String getParentName() {
        return "sampl/lang/ConstraintMap";
    }

    @Override
    Decl getDecl() {
        return this.decl;
    }

    @Override
    void emitConstructor() {
        MethodEmitter me = this.classEmitter.beginMethod(1, "<init>", "(Lsampl/lang/SAMPL;Ljava/lang/String;)V");
        MethodVisitor mv = me.getMethodVisitor();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitInsn(this.robustness != null ? 4 : 3);
        mv.visitMethodInsn(183, this.getParentName(), "<init>", "(Lsampl/lang/SAMPL;Ljava/lang/String;Z)V");
        mv.visitInsn(177);
        me.endMethod();
    }

    @Override
    void emitItem(MethodEmitter initEmitter) {
        MethodVisitor mv = initEmitter.getMethodVisitor();
        mv.visitInsn(14);
        mv.visitMethodInsn(183, "sampl/lang/ConstraintMap", "addConstraint", "(Ljava/lang/Object;D)Lsampl/lang/Constraint;");
        if (this.decl.getExpr() == null) {
            mv.visitInsn(89);
            mv.visitInsn(14);
            mv.visitInsn(14);
            mv.visitMethodInsn(182, "sampl/lang/Constraint", "setBounds", "(DD)V");
        }
        if (this.robustness != null) {
            initEmitter.emitNumber(this.robustness.getValue());
            mv.visitMethodInsn(182, "sampl/lang/Constraint", "setRobustness", "(D)V");
        } else {
            mv.visitInsn(87);
        }
    }

    @Override
    void emitMembers() {
        super.emitMembers();
        Expr expr = this.decl.getExpr();
        if (expr == null) {
            return;
        }
        MethodEmitter me = this.classEmitter.beginMethod(17, "doExpand", "()V");
        MethodVisitor mv = me.getMethodVisitor();
        this.prepareEnvironment(me);
        Indexing indexing = this.decl.getIndexing();
        this.indexingEmitter = null;
        if (indexing != null) {
            this.indexingEmitter = new IndexingCompiler(me, indexing, true);
            this.indexingEmitter.start();
        }
        mv.visitVarInsn(25, 0);
        if (indexing != null) {
            mv.visitVarInsn(25, this.indexingEmitter.getKeyVar());
        } else {
            mv.visitInsn(1);
        }
        mv.visitMethodInsn(182, "sampl/lang/ConstraintMap", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "sampl/lang/Constraint");
        Expr lower = null;
        Expr upper = null;
        Expr rhs = null;
        if (expr instanceof BinaryExpr) {
            BinaryExpr binary = (BinaryExpr)expr;
            expr = binary.getLHS();
            rhs = binary.getRHS();
            switch (binary.getKind()) {
                default: {
                    assert (false) : "Invalid binary operator.";
                }
                case LE: {
                    upper = rhs;
                    break;
                }
                case GE: {
                    lower = rhs;
                    break;
                }
                case EQ: {
                    lower = upper = rhs;
                }
            }
            if (rhs.getType() == Types.NUMERIC) {
                rhs = null;
            }
        } else {
            DoubleInequalityExpr die = (DoubleInequalityExpr)expr;
            expr = die.getMid();
            if (die.isLessEqual()) {
                lower = die.getLHS();
                upper = die.getRHS();
            } else {
                upper = die.getLHS();
                lower = die.getRHS();
            }
        }
        int exprBuilderVar = me.emitRuntimeExpr(expr, 0);
        if (rhs != null) {
            mv.visitMethodInsn(182, "sampl/lang/ExprBuilder", "neg", "()V");
            me.emitRuntimeExpr(rhs, exprBuilderVar);
        }
        if (lower == null) {
            mv.visitLdcInsn((Object)Double.NEGATIVE_INFINITY);
        } else if (rhs != null) {
            mv.visitInsn(14);
        } else {
            me.emitNumeric(lower);
        }
        if (upper == null) {
            mv.visitLdcInsn((Object)Double.POSITIVE_INFINITY);
        } else if (rhs != null) {
            mv.visitInsn(14);
        } else if (lower == upper) {
            mv.visitInsn(92);
        } else {
            me.emitNumeric(upper);
        }
        mv.visitMethodInsn(182, "sampl/lang/Constraint", "setExpr", "(Lsampl/lang/ExprBuilder;DD)V");
        if (indexing != null) {
            this.indexingEmitter.end();
        }
        mv.visitInsn(177);
        me.endMethod();
    }

    @Override
    public void visit(SuffixAttr attr) {
        if (attr.getSuffix() == Suffix.robustness) {
            this.robustness = attr;
        }
    }
}

