/*
 * Decompiled with CFR 0.152.
 */
package sampl.codegen;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import sampl.ast.CheckDecl;
import sampl.ast.ConstraintDecl;
import sampl.ast.Decl;
import sampl.ast.DeclVisitor;
import sampl.ast.Expr;
import sampl.ast.Indexing;
import sampl.ast.ObjectiveDecl;
import sampl.ast.ParameterDecl;
import sampl.ast.ProblemDecl;
import sampl.ast.SetDecl;
import sampl.ast.Stmt;
import sampl.ast.TableDecl;
import sampl.ast.TreeDecl;
import sampl.ast.VariableDecl;
import sampl.codegen.ClassEmitter;
import sampl.codegen.ConstraintDeclCompiler;
import sampl.codegen.IndexingCompiler;
import sampl.codegen.MethodEmitter;
import sampl.codegen.ObjectiveDeclCompiler;
import sampl.codegen.ParameterDeclCompiler;
import sampl.codegen.ProblemDeclCompiler;
import sampl.codegen.SetDeclCompiler;
import sampl.codegen.TableDeclCompiler;
import sampl.codegen.TreeDeclCompiler;
import sampl.codegen.VariableDeclCompiler;
import sampl.sema.ASTConsumer;

public abstract class AbstractASTCompiler
implements ASTConsumer {
    private String blockClassName;
    private ClassEmitter blockClassEmitter;
    private MethodEmitter blockMethodEmitter;
    private int blockID;
    private int checkID;

    private void createBlock() {
        String className;
        if (this.blockClassName == null) {
            ++this.blockID;
            className = "Block" + this.blockID;
        } else {
            className = this.blockClassName;
        }
        this.blockClassEmitter = new ClassEmitter(this.getClassVisitor(), className, "java/lang/Object", "sampl/lang/Block");
        this.blockClassEmitter.emitDefaultConstructor();
        this.blockMethodEmitter = this.blockClassEmitter.beginMethod(17, "execute", "(Lsampl/lang/SAMPL;)V");
    }

    protected abstract ClassVisitor getClassVisitor();

    void setBlockClassName(String name) {
        this.blockClassName = name;
    }

    @Override
    public void onDecl(Decl decl) {
        if (!decl.isValid()) {
            return;
        }
        decl.accept(new DeclVisitor(){

            @Override
            public void visit(SetDecl decl) {
                new SetDeclCompiler(AbstractASTCompiler.this, decl).emitDecl();
            }

            @Override
            public void visit(ParameterDecl decl) {
                new ParameterDeclCompiler(AbstractASTCompiler.this, decl).emitDecl();
            }

            @Override
            public void visit(VariableDecl decl) {
                new VariableDeclCompiler(AbstractASTCompiler.this, decl).emitDecl();
            }

            @Override
            public void visit(ObjectiveDecl decl) {
                new ObjectiveDeclCompiler(AbstractASTCompiler.this, decl).emitDecl();
            }

            @Override
            public void visit(ConstraintDecl decl) {
                new ConstraintDeclCompiler(AbstractASTCompiler.this, decl).emitDecl();
            }

            @Override
            public void visit(ProblemDecl decl) {
                new ProblemDeclCompiler(AbstractASTCompiler.this, decl).emitDecl();
            }

            @Override
            public void visit(CheckDecl decl) {
                AbstractASTCompiler abstractASTCompiler = AbstractASTCompiler.this;
                abstractASTCompiler.checkID = abstractASTCompiler.checkID + 1;
                String className = "generated/Check" + AbstractASTCompiler.this.checkID;
                ClassEmitter ce = new ClassEmitter(AbstractASTCompiler.this.getClassVisitor(), className, "java/lang/Object", "sampl/lang/Block");
                ce.emitDefaultConstructor();
                MethodEmitter me = ce.beginMethod(17, "execute", "(Lsampl/lang/SAMPL;)V");
                MethodVisitor mv = me.getMethodVisitor();
                me.getVarIndex();
                Indexing indexing = decl.getIndexing();
                IndexingCompiler emitter = null;
                if (indexing != null) {
                    emitter = new IndexingCompiler(me, decl.getIndexing());
                    emitter.start();
                }
                Expr arg = decl.getExpr();
                String formattedArg = me.format(arg);
                me.emitLogical(arg);
                mv.visitLdcInsn((Object)formattedArg);
                mv.visitMethodInsn(184, "sampl/lang/SAMPL", "check", "(ZLjava/lang/String;)V");
                if (indexing != null) {
                    emitter.end();
                }
                mv.visitInsn(177);
                me.endMethod();
                ce.end();
                AbstractASTCompiler.this.getBlockMethodEmitter().emitEnvironmentRef();
                mv = AbstractASTCompiler.this.blockMethodEmitter.getMethodVisitor();
                mv.visitFieldInsn(180, "sampl/lang/SAMPL", "checks", "Ljava/util/List;");
                mv.visitTypeInsn(187, className);
                mv.visitInsn(89);
                mv.visitMethodInsn(183, className, "<init>", "()V");
                mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z");
            }

            @Override
            public void visit(TableDecl decl) {
                new TableDeclCompiler(AbstractASTCompiler.this, decl).emitDecl();
            }

            @Override
            public void visit(TreeDecl decl) {
                new TreeDeclCompiler(AbstractASTCompiler.this, decl).emitDecl();
            }
        });
    }

    @Override
    public void onTopLevelStmt(Stmt stmt) {
        stmt.accept(this.getBlockMethodEmitter());
    }

    public String endBlock() {
        if (this.blockMethodEmitter == null) {
            return null;
        }
        this.blockMethodEmitter.getMethodVisitor().visitInsn(177);
        this.blockMethodEmitter.endMethod();
        this.blockMethodEmitter = null;
        this.blockClassEmitter.end();
        return this.blockClassEmitter.getName();
    }

    ClassEmitter getBlockClassEmitter() {
        if (this.blockMethodEmitter == null) {
            this.createBlock();
        }
        return this.blockClassEmitter;
    }

    MethodEmitter getBlockMethodEmitter() {
        if (this.blockMethodEmitter == null) {
            this.createBlock();
        }
        return this.blockMethodEmitter;
    }
}

