/*
 * Decompiled with CFR 0.152.
 */
package sampl.codegen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import sampl.Source;
import sampl.Tuple;
import sampl.ast.ParameterDecl;
import sampl.ast.SetDecl;
import sampl.codegen.AbstractASTCompiler;
import sampl.codegen.ClassEmitter;
import sampl.codegen.MethodEmitter;

public class ASTCompiler
extends AbstractASTCompiler {
    private String outputDir;
    private boolean hasName;
    private int setterVar;
    private MethodEmitter mainMethodEmitter;

    private void emitObject(Object value) {
        MethodVisitor mv = this.mainMethodEmitter.getMethodVisitor();
        if (!(value instanceof Tuple)) {
            mv.visitLdcInsn(value);
            if (value instanceof Double) {
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            }
            return;
        }
        Tuple t = (Tuple)value;
        mv.visitTypeInsn(187, "sampl/Tuple");
        mv.visitInsn(89);
        int size = t.size();
        mv.visitIntInsn(16, size);
        mv.visitTypeInsn(189, "java/lang/Object");
        int i = 0;
        while (i < size) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, i);
            this.emitObject(t.get(i));
            mv.visitInsn(83);
            ++i;
        }
        mv.visitMethodInsn(183, "sampl/Tuple", "<init>", "([Ljava/lang/Object;)V");
    }

    private void createSetter() {
        this.mainMethodEmitter = this.getBlockMethodEmitter();
        this.setterVar = this.mainMethodEmitter.getVarIndex();
        MethodVisitor mv = this.mainMethodEmitter.getMethodVisitor();
        mv.visitTypeInsn(187, "sampl/lang/DataSetter");
        mv.visitInsn(89);
        this.mainMethodEmitter.emitEnvironmentRef();
        mv.visitMethodInsn(183, "sampl/lang/DataSetter", "<init>", "(Lsampl/lang/SAMPL;)V");
        mv.visitVarInsn(58, this.setterVar);
    }

    @Override
    protected ClassVisitor getClassVisitor() {
        return new ClassWriter(2){
            private String name;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, name, signature, superName, interfaces);
                this.name = name;
            }

            public void visitEnd() {
                super.visitEnd();
                FileOutputStream out = null;
                try {
                    try {
                        this.name = this.name.replace('/', File.separatorChar);
                        File file = new File(ASTCompiler.this.outputDir, this.name);
                        File parent = file.getParentFile();
                        if (parent != null) {
                            parent.mkdirs();
                        }
                        out = new FileOutputStream(String.valueOf(file.getPath()) + ".class");
                        out.write(this.toByteArray());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        };
    }

    public ASTCompiler(String outputDir) {
        this.outputDir = outputDir;
    }

    @Override
    public void onSourceSwitch(Source s) {
        if (this.hasName) {
            return;
        }
        String name = s.getName();
        int extPos = name.lastIndexOf(46);
        if (extPos != -1) {
            name = name.substring(0, extPos);
        }
        this.setBlockClassName(name);
        this.hasName = true;
    }

    @Override
    public void onSourcesEnd() {
        ClassEmitter ce = this.getBlockClassEmitter();
        MethodEmitter main = ce.beginMethod(9, "main", "([Ljava/lang/String;)V");
        String mainClassName = ce.getName();
        MethodVisitor mv = main.getMethodVisitor();
        mv.visitTypeInsn(187, mainClassName);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, mainClassName, "<init>", "()V");
        mv.visitMethodInsn(184, "sampl/lang/SAMPL", "execute", "(Lsampl/lang/Block;)V");
        mv.visitInsn(177);
        main.endMethod();
        this.endBlock();
    }

    @Override
    public void onDataStart(SetDecl decl, Object key) {
        if (this.setterVar == 0) {
            this.createSetter();
        }
        MethodVisitor mv = this.mainMethodEmitter.getMethodVisitor();
        mv.visitVarInsn(25, this.setterVar);
        mv.visitLdcInsn((Object)decl.getName());
        if (key != null) {
            this.emitObject(key);
        } else {
            mv.visitInsn(1);
        }
        mv.visitMethodInsn(182, "sampl/lang/DataSetter", "enterData", "(Ljava/lang/String;Ljava/lang/Object;)V");
    }

    @Override
    public void onDataStart(ParameterDecl[] decls) {
        if (this.setterVar == 0) {
            this.createSetter();
        }
        MethodVisitor mv = this.mainMethodEmitter.getMethodVisitor();
        mv.visitVarInsn(25, this.setterVar);
        mv.visitIntInsn(16, decls.length);
        mv.visitTypeInsn(189, "sampl/lang/Parameter");
        int i = 0;
        while (i < decls.length) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, i);
            this.mainMethodEmitter.emitEnvironmentRef();
            mv.visitLdcInsn((Object)decls[i].getName());
            mv.visitMethodInsn(182, "sampl/lang/SAMPL", "getEntity", "(Ljava/lang/String;)Lsampl/lang/Entity;");
            mv.visitTypeInsn(192, "sampl/lang/Parameter");
            mv.visitInsn(83);
            ++i;
        }
        mv.visitMethodInsn(182, "sampl/lang/DataSetter", "enterData", "([Lsampl/lang/Parameter;)V");
    }

    @Override
    public void onKey(Object key) {
        MethodVisitor mv = this.mainMethodEmitter.getMethodVisitor();
        mv.visitVarInsn(25, this.setterVar);
        this.emitObject(key);
        mv.visitMethodInsn(182, "sampl/lang/DataSetter", "addKey", "(Ljava/lang/Object;)V");
    }

    @Override
    public void onData(Object value) {
        MethodVisitor mv = this.mainMethodEmitter.getMethodVisitor();
        mv.visitVarInsn(25, this.setterVar);
        this.emitObject(value);
        mv.visitMethodInsn(182, "sampl/lang/DataSetter", "addData", "(Ljava/lang/Object;)V");
    }

    @Override
    public void onDefaultData(Object value) {
        MethodVisitor mv = this.mainMethodEmitter.getMethodVisitor();
        mv.visitVarInsn(25, this.setterVar);
        this.emitObject(value);
        mv.visitMethodInsn(182, "sampl/lang/DataSetter", "setDefaultData", "(Ljava/lang/Object;)V");
    }

    @Override
    public void onData(Object key, Object value, int index) {
        MethodVisitor mv = this.mainMethodEmitter.getMethodVisitor();
        mv.visitVarInsn(25, this.setterVar);
        this.emitObject(key);
        this.emitObject(value);
        mv.visitIntInsn(16, index);
        mv.visitMethodInsn(182, "sampl/lang/DataSetter", "addData", "(Ljava/lang/Object;Ljava/lang/Object;I)V");
    }
}

