/*
 * Decompiled with CFR 0.152.
 */
package sampl.ast;

import sampl.ast.Indexing;
import sampl.ast.Referable;
import sampl.types.Type;
import sampl.types.Types;

public enum Suffix implements Referable
{
    astatus(15, Types.STRING),
    body(4),
    defeqn(1, false, true, Types.NUMERIC),
    defvar(4, false, true, Types.NUMERIC),
    dinit(4),
    dinit0(4),
    ldual(4),
    udual(4),
    dual(5),
    init,
    init0,
    lb(5),
    ub(5),
    lb0,
    ub0,
    lb1,
    ub1,
    lb2,
    ub2,
    lrc,
    urc,
    lbs(4),
    ubs(4),
    lslack(5),
    uslack(5),
    rc,
    slack(5),
    sstatus(15, true, false, Types.STRING),
    status(5, Types.STRING),
    val(3),
    exitcode(10),
    message(10),
    result(10),
    stage(1, true, true, Types.NUMERIC),
    robustness(4, true, false, Types.NUMERIC);

    private Type type;
    private int targets;
    private boolean assignable;
    private boolean internal;
    public static final int VARIABLE = 1;
    public static final int OBJECTIVE = 2;
    public static final int CONSTRAINT = 4;
    public static final int PROBLEM = 8;

    private Suffix(int targets, boolean assignable, boolean internal, Type t) {
        this.type = t;
        this.targets = targets;
        this.assignable = assignable;
        this.internal = internal;
    }

    private Suffix(int targets) {
        this(targets, false, false, Types.NUMERIC);
    }

    private Suffix(int targets, Type type) {
        this.type = type;
        this.targets = targets;
        this.internal = true;
    }

    private Suffix() {
        this(1, false, false, Types.NUMERIC);
    }

    public final boolean supports(Referable decl) {
        return (this.targets & decl.getSuffixTarget()) != 0;
    }

    public boolean isAssignable() {
        return this.assignable;
    }

    public boolean isInternal() {
        return this.internal;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public String getClassName() {
        return null;
    }

    @Override
    public Indexing getIndexing() {
        return null;
    }

    @Override
    public int getSuffixTarget() {
        return 0;
    }
}

