/*
 * Decompiled with CFR 0.152.
 */
package sampl.ast;

import sampl.ast.Expr;
import sampl.ast.ExprVisitor;
import sampl.ast.Referable;
import sampl.parser.Identifier;
import sampl.types.Type;

public class Reference
extends Expr {
    private Identifier id;
    private Referable target;

    public Reference(int start, Type type, Identifier id, Referable target) {
        super(start, start + id.length() - 1, type);
        this.id = id;
        this.target = target;
    }

    public Identifier getIdentifier() {
        return this.id;
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public Referable getTarget() {
        return this.target;
    }

    @Override
    public Type getOriginalType() {
        return this.target.getType();
    }

    @Override
    public boolean isAssignable() {
        return true;
    }

    @Override
    public void format(StringBuilder sb) {
        sb.append(this.target.getName());
    }

    @Override
    public void accept(ExprVisitor visitor) {
        visitor.visit(this);
    }
}

