/*
 * Decompiled with CFR 0.152.
 */
package sampl.ast;

import java.util.List;
import sampl.ast.Expr;
import sampl.ast.ExprVisitor;
import sampl.types.Type;

public class ParenExpr
extends Expr {
    private List<Expr> items;

    public ParenExpr(int start, int end, Type type, List<Expr> items) {
        super(start, end, type);
        this.items = items;
    }

    public int getNumItems() {
        return this.items.size();
    }

    public List<Expr> getItems() {
        return this.items;
    }

    public Expr getItem(int i) {
        return this.items.get(i);
    }

    @Override
    public void format(StringBuilder sb) {
        sb.append('(');
        ParenExpr.formatList(sb, this.items);
        sb.append(')');
    }

    @Override
    public void accept(ExprVisitor visitor) {
        visitor.visit(this);
    }
}

