/*
 * Decompiled with CFR 0.152.
 */
package sampl.ast;

import java.util.ArrayList;
import java.util.List;
import sampl.ast.Expr;
import sampl.ast.ExprVisitor;
import sampl.types.SetType;
import sampl.types.Type;

public class Indexing
extends Expr {
    private List<Expr> parts;
    private Expr condition;
    private int scenarioPartIndex;
    private int scenarioSubIndex;

    public Indexing(int start, int end, Type type, List<Expr> parts, Expr condition) {
        super(start, end, type);
        this.parts = parts;
        this.condition = condition;
        this.scenarioPartIndex = -1;
        this.scenarioSubIndex = -1;
    }

    public int getNumParts() {
        return this.parts.size();
    }

    public List<Expr> getParts() {
        return this.parts;
    }

    public Expr getPart(int i) {
        return this.parts.get(i);
    }

    public Expr getCondition() {
        return this.condition;
    }

    public boolean hasScenarioIndex() {
        return this.scenarioPartIndex >= 0;
    }

    public int getScenarioPartIndex() {
        return this.scenarioPartIndex;
    }

    public int getScenarioSubIndex() {
        return this.scenarioSubIndex;
    }

    public void setScenarioIndices(int partIndex, int subIndex) {
        this.scenarioPartIndex = partIndex;
        this.scenarioSubIndex = subIndex;
    }

    public Indexing copyWithoutScenarioSet() {
        if (this.parts.size() == 1) {
            return null;
        }
        ArrayList<Expr> parts = new ArrayList<Expr>(this.parts);
        parts.remove(this.scenarioPartIndex);
        SetType type = SetType.get(this.getDimension() - 1);
        return new Indexing(this.getStart(), this.getEnd(), type, parts, this.condition);
    }

    @Override
    public void format(StringBuilder sb) {
        sb.append('{');
        Indexing.formatList(sb, this.parts);
        if (this.condition != null) {
            sb.append(": ");
            this.condition.format(sb);
        }
        sb.append('}');
    }

    @Override
    public void accept(ExprVisitor visitor) {
        visitor.visit(this);
    }
}

