/*
 * Decompiled with CFR 0.152.
 */
package sampl.ast;

import sampl.ast.Indexing;
import sampl.ast.Referable;
import sampl.types.Type;
import sampl.types.Types;

public enum Function implements Referable
{
    abs("D"),
    acos("D"),
    asin("D"),
    atan("D"),
    atan2("DD"),
    ceil("D"),
    cos("D"),
    exp("D"),
    floor("D"),
    log("D"),
    max("DD", Kind.VARARG),
    min("DD", Kind.VARARG),
    round("D"),
    sin("D"),
    sqrt("D"),
    tan("D"),
    card("S", Kind.STATIC),
    Normal("DD", Kind.NONSTATIC),
    Normal01("", Kind.NONSTATIC),
    Uniform("DD", Kind.NONSTATIC),
    Uniform01("", Kind.NONSTATIC);

    private String argTypes;
    private Kind kind;

    private Function(String argTypes, Kind kind) {
        this.argTypes = argTypes;
        this.kind = kind;
    }

    private Function(String argTypes) {
        this(argTypes, Kind.MATH);
    }

    public String getArgTypes() {
        return this.argTypes;
    }

    public Kind getKind() {
        return this.kind;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public Type getType() {
        return Types.FUNCTION;
    }

    @Override
    public String getClassName() {
        return null;
    }

    @Override
    public Indexing getIndexing() {
        return null;
    }

    @Override
    public int getSuffixTarget() {
        return 0;
    }

    public static enum Kind {
        MATH,
        VARARG,
        STATIC,
        NONSTATIC;

    }
}

