/*
 * Decompiled with CFR 0.152.
 */
package sampl.ast;

import sampl.ast.Expr;
import sampl.ast.ExprVisitor;
import sampl.types.Type;

public class DoubleInequalityExpr
extends Expr {
    private boolean lessEqual;
    private Expr lhs;
    private Expr mid;
    private Expr rhs;

    public DoubleInequalityExpr(Type type, boolean lessEqual, Expr lhs, Expr mid, Expr rhs) {
        super(lhs.getStart(), rhs.getEnd(), type);
        this.lessEqual = lessEqual;
        this.lhs = lhs;
        this.mid = mid;
        this.rhs = rhs;
    }

    public boolean isLessEqual() {
        return this.lessEqual;
    }

    public Expr getLHS() {
        return this.lhs;
    }

    public Expr getMid() {
        return this.mid;
    }

    public Expr getRHS() {
        return this.rhs;
    }

    @Override
    public void format(StringBuilder sb) {
        String op = this.lessEqual ? " <= " : " >= ";
        this.lhs.format(sb);
        sb.append(op);
        this.mid.format(sb);
        sb.append(op);
        this.rhs.format(sb);
    }

    @Override
    public void accept(ExprVisitor visitor) {
        visitor.visit(this);
    }
}

