/*
 * Decompiled with CFR 0.152.
 */
package sampl.ast;

import sampl.ast.Expr;
import sampl.ast.ExprVisitor;
import sampl.types.Type;

public class ConditionalExpr
extends Expr {
    private Expr condition;
    private Expr thenExpr;
    private Expr elseExpr;

    public ConditionalExpr(int start, Type type, Expr condition, Expr thenExpr, Expr elseExpr) {
        super(start, (elseExpr != null ? elseExpr : thenExpr).getEnd(), type);
        this.condition = condition;
        this.thenExpr = thenExpr;
        this.elseExpr = elseExpr;
    }

    public Expr getCondition() {
        return this.condition;
    }

    public Expr getThen() {
        return this.thenExpr;
    }

    public Expr getElse() {
        return this.elseExpr;
    }

    @Override
    public void format(StringBuilder sb) {
        sb.append("if ");
        this.condition.format(sb);
        sb.append(" then ");
        this.thenExpr.format(sb);
        if (this.elseExpr != null) {
            sb.append(" else ");
            this.elseExpr.format(sb);
        }
    }

    @Override
    public void accept(ExprVisitor visitor) {
        visitor.visit(this);
    }
}

