/*
 * Decompiled with CFR 0.152.
 */
package sampl.ast;

import java.util.Collections;
import java.util.List;
import sampl.ast.Expr;
import sampl.ast.ExprVisitor;
import sampl.ast.Function;
import sampl.types.Type;

public class CallExpr
extends Expr {
    private Function func;
    private List<Expr> args;

    public CallExpr(int start, int end, Type type, Function f, List<Expr> args) {
        super(start, end, type);
        this.func = f;
        this.args = args != null ? args : Collections.emptyList();
    }

    public List<Expr> getArgs() {
        return this.args;
    }

    public Function getFunction() {
        return this.func;
    }

    @Override
    public void format(StringBuilder sb) {
        sb.append(this.func.getName());
        sb.append('(');
        CallExpr.formatList(sb, this.args);
        sb.append(')');
    }

    @Override
    public void accept(ExprVisitor visitor) {
        visitor.visit(this);
    }
}

