/*
 * Decompiled with CFR 0.152.
 */
package sampl.ast;

import sampl.ast.Expr;
import sampl.ast.ExprVisitor;
import sampl.ast.Referable;
import sampl.types.Type;

public class BinaryExpr
extends Expr {
    private Kind kind;
    private Expr lhs;
    private Expr rhs;

    public BinaryExpr(Type type, Kind kind, Expr lhs, Expr rhs) {
        super(lhs.getStart(), rhs.getEnd(), type);
        this.kind = kind;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Expr getLHS() {
        return this.lhs;
    }

    public Expr getRHS() {
        return this.rhs;
    }

    @Override
    public void format(StringBuilder sb) {
        this.lhs.format(sb);
        sb.append(' ');
        sb.append(this.kind.toString());
        sb.append(' ');
        this.rhs.format(sb);
    }

    @Override
    public void accept(ExprVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Referable getTarget() {
        return this.kind == Kind.TILDE ? this.rhs.getTarget() : null;
    }

    public static enum Kind {
        EXP("^"),
        MUL("*"),
        DIV("/"),
        IDIV("div"),
        MOD("mod"),
        ADD("+"),
        SUB("-"),
        LESS("less"),
        UNION("union"),
        DIFF("diff"),
        SYMDIFF("symdiff"),
        CROSS("cross"),
        CONCAT("&"),
        IN("in"),
        NOTIN("not in"),
        LT("<"),
        GT(">"),
        LE("<="),
        GE(">="),
        EQ("=="),
        NE("!="),
        OR("||"),
        AND("&&"),
        COMPLEMENTS("complements"),
        TILDE("~");

        private String op;

        private Kind(String op) {
            this.op = op;
        }

        public String toString() {
            return this.op;
        }
    }
}

