/*
 * Decompiled with CFR 0.152.
 */
package sampl;

public final class Util {
    public static final String NEWLINE = System.getProperty("line.separator");
    private static final boolean replaceLineSep = !NEWLINE.equals("\n");

    private Util() {
    }

    public static String format(double d) {
        int length;
        String s = Double.toString(d);
        if (s.charAt((length = s.length()) - 1) == '0') {
            if (s.charAt(length - 2) == '.') {
                return s.substring(0, length - 2);
            }
            double absValue = Math.abs(d);
            if (absValue >= 0.001 && absValue < 1.0E8) {
                return s.substring(0, length - 1);
            }
        }
        return s;
    }

    public static String format(Object obj) {
        if (obj instanceof Double) {
            return Util.format((Double)obj);
        }
        return obj.toString();
    }

    public static String quote(String str) {
        int length = str.length();
        StringBuilder sb = new StringBuilder(length + 2);
        int QUOTE = 39;
        sb.append('\'');
        int i = 0;
        while (i < length) {
            char c = str.charAt(i);
            if (c == '\'') {
                sb.append('\'');
            } else if (c == '\n') {
                sb.append('\\');
            }
            sb.append(c);
            ++i;
        }
        sb.append('\'');
        return sb.toString();
    }

    public static String unquote(String str) {
        String MESSAGE = "Argument is not a valid AMPL string";
        int length = str.length();
        if (length < 2) {
            throw new IllegalArgumentException("Argument is not a valid AMPL string");
        }
        char quote = str.charAt(0);
        if (quote != '\'' && quote != '\"' || str.charAt(length - 1) != quote) {
            throw new IllegalArgumentException("Argument is not a valid AMPL string");
        }
        StringBuilder sb = new StringBuilder(length - 2);
        int i = 1;
        while (i < length - 1) {
            if (str.charAt(i) == quote || str.charAt(i) == '\\' && str.charAt(i + 1) == '\n') {
                ++i;
            }
            sb.append(str.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    public static String toSystemNewlines(String s) {
        return replaceLineSep ? s.replace("\n", NEWLINE) : s;
    }

    public static double intdiv(double a, double b) {
        return (a /= b) >= 0.0 ? Math.floor(a) : Math.ceil(a);
    }
}

