/*
 * Decompiled with CFR 0.152.
 */
package sampl;

import java.util.Arrays;
import sampl.Util;

public final class Tuple {
    private final Object[] elements;

    private Tuple(Object[] elements, int from, int to) {
        this.elements = Arrays.copyOfRange(elements, from, to);
    }

    public Tuple(Object ... elements) {
        this.elements = Arrays.copyOf(elements, elements.length);
    }

    public int size() {
        return this.elements.length;
    }

    public Object get(int index) {
        return this.elements[index];
    }

    public Tuple subtuple(int from, int to) {
        if (to > this.elements.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new Tuple(this.elements, from, to);
    }

    public Object[] elements() {
        return Arrays.copyOf(this.elements, this.elements.length);
    }

    public void insert(Object[] array, int index) {
        int i = 0;
        int n = this.elements.length;
        while (i < n) {
            array[index + i] = this.elements[i];
            ++i;
        }
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Tuple && Arrays.equals(this.elements, ((Tuple)other).elements);
    }

    public int hashCode() {
        return Arrays.hashCode(this.elements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        int n = this.elements.length;
        if (n != 0) {
            sb.append(Util.format(this.elements[0]));
            int i = 1;
            while (i < n) {
                sb.append(',');
                sb.append(Util.format(this.elements[i]));
                ++i;
            }
        }
        sb.append(')');
        return sb.toString();
    }

    public Tuple clone() {
        return new Tuple(this.elements);
    }
}

