/*
 * Decompiled with CFR 0.152.
 */
package sampl;

import sampl.Diagnostic;
import sampl.SAMPLException;
import sampl.Source;

public class DiagnosticException
extends SAMPLException
implements Diagnostic {
    private static final long serialVersionUID = 0L;
    private String sourceName;
    private int lineNumber;
    private int columnNumber;

    public DiagnosticException(String message, Source source, int offset) {
        super(message);
        if (source == null) {
            return;
        }
        this.sourceName = source.getName();
        if (offset < 0) {
            return;
        }
        this.lineNumber = source.getLineNumber(offset);
        this.columnNumber = source.getColumnNumber(offset, this.lineNumber);
        assert (this.lineNumber >= 0 && this.columnNumber >= 0);
    }

    public DiagnosticException(String message, Source source, int lineNumber, int columnNumber) {
        super(message);
        if (source != null) {
            this.sourceName = source.getName();
        }
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }
}

