# Claudia D'Ambrosio, CNRS&LIX, Ecole Polytechnique
# portfolio selection model

param n > 0;
param R > 0;

param corr{1..n,1..n};
param exp_ret{1..n} > 0;

var x{1..n} >= 0, <= 1;
var y{1..n} binary;

minimize covariance:
	sum{i in 1..n, j in 1..n} corr[i,j]*x[i]*x[j];

subject to min_exp_ret:
	sum{i in 1..n} exp_ret[i]*x[i] >= R;

subject to sum_up_to_1:
	sum{i in 1..n} x[i] = 1;
 
subject to min_quantity{i in 1..n}:
	x[i] >= 0.1*y[i];

subject to max_quantity{i in 1..n}:
	x[i] <= 1*y[i];

