param N > 0; # number of items
param C > 0; # capacity
param U{j in 1..N} > 0; # upper bound on quantity of item i

# it is sufficient to modify the value of this param to change objective function type (1 = exo 1, 2 = exo 4, 3 = exo 5)
param profit_type <=3, >=1, integer default 1;

# objective function coefficients
param a{1..N} > 0;
param b{1..N} > 0;
param c{1..N} > 0;
param d{1..N} < 0;

# variables
var x{j in 1..N} >= 0, <= U[j];

# objective function
maximize Profit:
  if profit_type == 1 then sum{j in 1..N} (a[j] + b[j]*x[j] + c[j]*x[j]**2 + d[j]*x[j]**3) else
  if profit_type == 2 then sum{j in 1..N} (d[j] + c[j]*x[j] + b[j]*x[j]**2 + a[j]*x[j]**3) else
  if profit_type == 3 then sum{j in 1..N} c[j]/(1+b[j]*exp(-a[j]*(x[j]+d[j])));

# constraints
subject to Knapsack_constraint:
  sum{j in 1..N} x[j] <= C;




