param n >0, default 10;
param C{i in 1..n, j in 1..n: i<j} binary, default round(Uniform(0,1));
param D{k in 1..n, l in 1..n};# default Uniform(0, 100);

var x{1..n,1..n} <=1, >=0, binary;
var w{1..n,1..n,1..n,1..n} <=1, >=0, binary;

minimize of:
  sum{i in 1..n, j in 1..n: i<j && C[i,j]==1} sum{k in 1..n, l in 1..n: k!=l} D[k,l]*w[i,k,j,l];

subject to Constr1{i in 1..n}:
  sum{k in 1..n} x[i,k] = 1;

subject to Constr2{k in 1..n}:
  sum{i in 1..n} x[i,k] = 1;

subject to wConstr1{i in 1..n, j in 1..n, k in 1..n, l in 1..n}:
  w[i,k,j,l] <= x[i,k];

subject to wConstr2{i in 1..n, j in 1..n, k in 1..n, l in 1..n}:
  w[i,k,j,l] <= x[j,l];

subject to wConstr3{i in 1..n, j in 1..n, k in 1..n, l in 1..n}:
  w[i,k,j,l] >= x[i,k] + x[j,l] - 1;




