param npoints > 0, default 10;
set L := 1..npoints;
param X{L}, default Uniform(-10,10);
param Y{L}, default Uniform(-10,10);
param minX := min{i in L} X[i];
param maxX := max{i in L} X[i];
param minY := min{i in L} Y[i];
param maxY := max{i in L} Y[i];
param Rad > 0, default 2;
param P > 0, default 3;
param F > 0, default 10;

param nmaxradar > 0, default 20;
set R := 1..nmaxradar;
param XR{R} default Uniform(minX,maxX);
param YR{R} default Uniform(minY,maxY);
var w{L,R} <=1, >= 0, binary;
var z{R} <=1, >= 0, binary;

minimize nradar:
  sum{j in R} F*z[j];

subject to maxCapacity{j in R}:
  sum{i in L} w[i,j] <= P*z[j];

subject to maxRadius{i in L, j in R}:
#  (X[i]-XR[j])**2 + (Y[i]-XR[j])**2 <= Rad*Rad + ((maxX-minX)**2+(maxY-minY)**2)*(1-w[i,j]);
  w[i,j] <= ((X[i]-XR[j])**2+(Y[i]-YR[j])**2)/(Rad*Rad);

subject to fullCover{i in L}:
  sum{j in R} w[i,j] = 1;

#subject to extraConstraintLBxR{j in L}:
#  xR[j] >= minX*z[j];

#subject to extraConstraintUBxR{j in L}:
#  xR[j] <= maxX*z[j];

#subject to extraConstraintLByR{j in L}:
#  yR[j] >= minY*z[j];

#subject to extraConstraintUByR{j in L}:
#  yR[j] <= maxY*z[j];


