param npoints > 0, default 10;
set L := 1..npoints;
param X{L}, default Uniform(-10,10);
param Y{L}, default Uniform(-10,10);
param minX := min{i in L} X[i];
param maxX := max{i in L} X[i];
param minY := min{i in L} Y[i];
param maxY := max{i in L} Y[i];
param R > 0, default 2;
param P > 0, default 4;
param F > 0, default 10;

var xR{L} <= maxX, >= minX;
var yR{L} <= maxY, >= minY;
var w{L,L} <=1, >= 0, binary;
var z{L} <=1, >= 0, binary;

minimize nradar:
  sum{j in L} F*z[j];

subject to maxCapacity{j in L}:
  sum{i in L} w[i,j] <= P*z[j];

subject to maxRadius{i in L, j in L}:
  (X[i]-xR[j])**2 + (Y[i]-yR[j])**2 <= R*R + ((maxX-minX)**2+(maxY-minY)**2)*(1-w[i,j]);

subject to fullCover{i in L}:
  sum{j in L} w[i,j] = 1;

subject to extraConstraintLBxR{j in L}:
  xR[j] >= minX*z[j];

subject to extraConstraintUBxR{j in L}:
  xR[j] <= maxX*z[j];

subject to extraConstraintLByR{j in L}:
  yR[j] >= minY*z[j];

subject to extraConstraintUByR{j in L}:
  yR[j] <= maxY*z[j];


