#Copyright 2020 Marianna Girlando, Lutz Straßburger.
#
#This file is part of MOIN. MOIN is free software: you can redistribute it
#and or modify it under the terms of the GNU General Public License as published
#by the Free Software Foundation, version 3 of the License.
#
#MOIN is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
#without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#PURPOSE. See the GNU General Public License for more details. You should have
#received a copy of the GNU General Public License along with MOIN. If not, see
#<http://www.gnu.org/licenses/>.

# invokes the Prolog prover
# first argument: the logic
# second argument: the formula
# if there is a proof, it runs pdflatex
# and shows the pdf with the proof


declare -A systemmap

systemmap[K]="k,[]"
systemmap[D]="k,[d]"
systemmap[KD]="k,[d]"
systemmap[T]="k,[t]"
systemmap[KT]="k,[t]"
systemmap[K4]="k,[4]"
systemmap[D4]="k,[d,4]"
systemmap[KD4]="k,[d,4]"
systemmap[S4]="k,[t,4]"
systemmap[KT4]="k,[t,4]"
systemmap[K5]="k,[5]"
systemmap[D5]="k,[d,5]"
systemmap[KD5]="k,[d,5]"
systemmap[K45]="k,[4,5]"
systemmap[D45]="k,[d,4,5]"
systemmap[KD45]="k,[d,4,5]"
systemmap[KB]="k,[b]"
systemmap[DB]="k,[d,b]"
systemmap[KDB]="k,[d,b]"
systemmap[TB]="k,[t,b]"
systemmap[KTB]="k,[t,b]"
systemmap[KB5]="k,[b,5]"
systemmap[S5]="k,[t,4,5]"
systemmap[KT5]="k,[t,4,5]"

systemmap[IKs]="i,[]"
systemmap[IDs]="i,[d]"
systemmap[IKDs]="i,[d]"
systemmap[ITs]="i,[t]"
systemmap[IKTs]="i,[t]"
systemmap[IK4s]="i,[4]"
systemmap[ID4s]="i,[d,4]"
systemmap[IKD4s]="i,[d,4]"
systemmap[IS4s]="i,[t,4]"
systemmap[IKT4s]="i,[t,4]"
systemmap[IK5s]="i,[5]"
systemmap[ID5s]="i,[d,5]"
systemmap[IKD5s]="i,[d,5]"
systemmap[IK45s]="i,[4,5]"
systemmap[ID45s]="i,[d,4,5]"
systemmap[IKD45s]="i,[d,4,5]"
systemmap[IKBs]="i,[b]"
systemmap[IDBs]="i,[d,b]"
systemmap[IKDBs]="i,[d,b]"
systemmap[ITBs]="i,[t,b]"
systemmap[IKTBs]="i,[t,b]"
systemmap[IKB5s]="i,[b,5]"
systemmap[IS5s]="i,[t,4,5]"
systemmap[IKT5s]="i,[t,4,5]"

systemmap[IKm]="m,[]"
systemmap[IDm]="m,[d]"
systemmap[IKDm]="m,[d]"
systemmap[ITm]="m,[t]"
systemmap[IKTm]="m,[t]"
systemmap[IK4m]="m,[4]"
systemmap[ID4m]="m,[d,4]"
systemmap[IKD4m]="m,[d,4]"
systemmap[IS4m]="m,[t,4]"
systemmap[IKT4m]="m,[t,4]"
systemmap[IK5m]="m,[5]"
systemmap[ID5m]="m,[d,5]"
systemmap[IKD5m]="m,[d,5]"
systemmap[IK45m]="m,[4,5]"
systemmap[ID45m]="m,[d,4,5]"
systemmap[IKD45m]="m,[d,4,5]"
systemmap[IKBm]="m,[b]"
systemmap[IDBm]="m,[d,b]"
systemmap[IKDBm]="m,[d,b]"
systemmap[ITBm]="m,[t,b]"
systemmap[IKTBm]="m,[t,b]"
systemmap[IKB5m]="m,[b,5]"
systemmap[IS5m]="m,[t,4,5]"
systemmap[IKT5m]="m,[t,4,5]"

#TODO finish the list

if [[ "$1" =~ ^(K|D|KD|T|KT|K4|D4|KD4|S4|KT4|K5|D5|KD5|K45|D45|KD45|KB|DB|KDB|TB|KTB|KB5|S5|KT5)$ ]]; then
    echo "classical modal logic"
    Filename='NK+X-result' 
else
    if [[ "$1" =~ ^(IKs|IDs|IKDs|ITs|IKTs|IK4s|ID4s|IKD4s|IS4s|IKT4s|IK5s|ID5s|IK45s|ID45s|IKBs|IDBs|IKDBs|ITBs|IKTBs|IKB5s|IS5s|IKT5s)$ ]]; then
	echo "intuitionistic modal logic"
	echo "single-conclusion system"
	Filename='NIKs+X-result' 
    else
	if [[ "$1" =~ ^(IKm|IDm|IKDm|ITm|IKTm|IK4m|ID4m|IKD4m|IS4m|IKT4m|IK5m|ID5m|IK45m|ID45m|IKBm|IDBm|IKDBm|ITBm|IKTBm|IKB5m|IS5m|IKT5m)$ ]]; then
	    echo "intuitionistic modal logic"
	    echo "multi-conclusion system"
	    Filename='NIKm+X-result'
	else
	    echo "$1 is not a system I can deal with"
	    exit
	fi
    fi
fi

time swipl -f moin.pl -g "derive(${systemmap[$1]},$2)" -t halt
pdflatex $Filename.tex > /dev/null 
evince $Filename.pdf &
exit
