#!/bin/sh

RUN=mrm.run
MOD=mrmlin_inv.mod

if [ "$1" = "" ] ; then
  echo "$0: missing .dat file on cmd line"
  echo " optional second argument is a nonlinear solver acting on the "
  echo "  nonlinear formulation mrm.mod instead of mrmlin.mod"
  exit 1
fi

if [ "$2" != "" ] ; then
  MOD=mrm_inv.mod
fi

echo "model $MOD;" > $RUN
echo "data $1;" >> $RUN
if [ "$2" = "" ] ; then 
  echo "option solver cplex;" >> $RUN
  echo "option cplex_options \"mipdisplay=2\";" >> $RUN
else
  echo "option solver $2;" >> $RUN
fi
echo "solve;" >> $RUN
cat <<EOF >> $RUN
display h, b, k, l;
printf "time instruction | registers (1,...)\n";
param status default 0;
for {t in T0} {
  if (x[0,t] = 0) then {
    printf "%d %d |", t, sum{i in N} i*x[i,t];
    for {j in M} {
      printf " %d", r[j,t] - 1;
    }
    printf "\n";
  } else {
    if (status = 0) then {
      printf "%d %d |", t, sum{i in N} i*x[i,t];
      for {j in M} {
        printf " %d", r[j,t] - 1;
      }
      printf " [halt]\n";
      let status := 1;
    } else {
      printf "%d terminated\n", t;
    }
  }
}

printf "hardest instance:\n";
for {j in M} {
  if (r0L[j] < r0U[j]) then {
    printf "r0[%d] = %d\n", j, r0[j] - 1;
  }
}
EOF
cat $RUN | ampl
