#!/bin/sh

RUN=mrm.run
MOD=mrmlin.mod

if [ "$1" = "" ] ; then
  echo "$0: missing .dat file on cmd line"
  echo " optional second argument is a nonlinear solver acting on the "
  echo "  nonlinear formulation mrm.mod instead of mrmlin.mod"
  exit 1
fi

if [ "$2" != "" ] ; then
  MOD=mrm.mod
fi

echo "model $MOD;" > $RUN
echo "data $1;" >> $RUN
if [ "$2" = "" ] ; then 
  echo "option solver cplex;" >> $RUN
  echo "option cplex_options \"mipdisplay=2\";" >> $RUN
else
  echo "option solver $2;" >> $RUN
fi
echo "solve;" >> $RUN
cat <<EOF >> $RUN
display h, b, k, l;
printf "time instruction registers (1,...)\n";
for {t in T0} {
  printf "%d %d", t, sum{i in N} i*x[i,t];
  for {j in M} {
    printf " %d", r[j,t] - 1;
  }
  printf "\n";
}
EOF
cat $RUN | ampl
