#define REGULAR_DATA_TYPE1 1
#define REGULAR_DATA_TYPE2 2

#define REGULAR_DATA_TYPE REGULAR_DATA_TYPE1

#if REGULAR_DATA_TYPE == REGULAR_DATA_TYPE1
typedef struct {
    qseq_t lq;
    struct hgcd_matrix *Q;
    int det, updateQ;
} __reg_struct;
#elif REGULAR_DATA_TYPE == REGULAR_DATA_TYPE2
typedef struct {
    qseq_t *lq; int nlq;
    struct hgcd_matrix *Q; /* FIXME: change this? */
    int det, updateQ; /* FIXME: change this? */
} __reg_struct;
#endif
typedef __reg_struct regular_t[1];

extern void regular_init(regular_t Q, mp_size_t lqn, mp_size_t Qn, int initlq, int updateQ);
extern void regular_clear(regular_t Q);
extern void regular_print(regular_t R);

extern int regular_are_norms_correct(regular_t R);
extern int regular_check_inequality(regular_t R, mp_ptr xi, mp_size_t xin, mp_ptr m, mp_size_t mn);
extern int check_Q_from_lq(struct hgcd_matrix *Q, qseq_t lq);

extern void regular_set_identity(regular_t R);
extern int regular_is_empty(regular_t R);
extern int regular_determinant(regular_t R);

extern void regular_save(int *Rfirst, int *Rfirst_large, int *det, regular_t R);
extern void regular_restore(regular_t R, int Rfirst, int Rfirst_large, int det);

extern void regular_mul_q(regular_t R, mp_ptr q, mp_size_t qn, mp_ptr tp, mp_size_t tp_alloc);
extern void regular_mul_qi(regular_t R, int i, mp_ptr tp, mp_size_t tp_alloc);
extern void regular_div_q(regular_t R, mp_ptr q, mp_size_t qn, mp_ptr tp, mp_size_t tp_alloc);
extern void regular_div_qi(regular_t R, int i, mp_ptr tp, mp_size_t tp_alloc);
extern void regular_init_set_q(regular_t R, int i);

extern void regular_add_last_mpn(regular_t R, mp_ptr q, mp_size_t qn, mp_ptr tp, mp_size_t tp_alloc);

extern void regular_omul_q(regular_t R, mp_ptr q, mp_size_t qn, mp_ptr tp, mp_size_t tp_alloc);
extern void regular_omul(regular_t R, regular_t S);

extern void regular_oslash(regular_t R, mp_ptr tp, mp_size_t tp_alloc);
void regular_oslash3(regular_t R, mp_ptr xi, mp_size_t *xin, mp_ptr xip1, mp_size_t *xip1n, mp_ptr tp, mp_size_t tp_alloc);

extern void qseq_build_product_plain_mpn(struct hgcd_matrix *M, qseq_t Q);
extern void qseq_build_product_plain(struct hgcd_matrix *M, qseq_t Q);
extern void qseq_build_product_tree(struct hgcd_matrix *M, qseq_t Q, size_t kmax);
extern void qseq_build_product(struct hgcd_matrix *M, qseq_t Q);

extern void regular_flush_lq(regular_t R, int Rfirst);
