#ifdef PRODUCTION
# define BUILD_PRODUCT_THRESHOLD1     8
# define BUILD_PRODUCT_THRESHOLD2  1250
#else
# define BUILD_PRODUCT_THRESHOLD1     8
# define BUILD_PRODUCT_THRESHOLD2  1250
#endif

#define QSEQ_FULL 1 /* I suspect bugs to appear in the 0 version */

#define QSEQ_DATA_TAB1 1
#define QSEQ_DATA_TAB2 2
#define QSEQ_DATA_TAB3 3

#define QSEQ_DATA_TYPE QSEQ_DATA_TAB3

#if QSEQ_DATA_TYPE == QSEQ_DATA_TAB1
#define TRICK_FOR_ONE  1
typedef struct {
    mp_ptr *tabq;
    size_t alloc;
    int first, last; /* tabq[first..last[ */
} __quot_seq_struct;
#elif QSEQ_DATA_TYPE == QSEQ_DATA_TAB2
#define TRICK_FOR_ONE 1 /* default, mandatory */
typedef struct {
    mp_limb_t *tabq;
    size_t alloc_q, alloc_ind;
    int *tind;
    int first, last; /* tabq[first..last[ */
} __quot_seq_struct;
#elif QSEQ_DATA_TYPE == QSEQ_DATA_TAB3
typedef struct {
    mp_limb_t *tab_large;
    mp_size_t *tab_large_nl;
    size_t alloc_large, alloc_ind;
    int *tind;
    int first, last;
    int first_large, last_large;
} __quot_seq_struct;
#endif

typedef __quot_seq_struct qseq_t[1];

#if QSEQ_DATA_TYPE == QSEQ_DATA_TAB1

#define qseq_card(S) ((S)->last - (S)->first)
#define qseq_n(S, i) (S)->tabq[(i)]+1
#define qseq_nl(S, i)  (S)->tabq[(i)][0]
#define qseq_is_cell_zero(S, i)	\
    (qseq_nl((S), (i)) == 1) && ((S)->tabq[(i)][1] == 0))

#elif QSEQ_DATA_TYPE == QSEQ_DATA_TAB2

#define qseq_card(S) ((S)->last-(S)->first)
#define qseq_n(S, i)  (S)->tabq+(S)->tind[(i)]
#define qseq_nl(S, i) (S)->tind[(i)+1]-(S)->tind[(i)]
#define qseq_is_cell_zero(S, i)	\
    ((qseq_nl((S), (i)) == 1) && ((S)->tabq[(S)->tind[(i)]] == 0))

extern void qseq_realloc_q(qseq_t Q, size_t sz);
extern void qseq_realloc_ind(qseq_t Q, size_t sz);

#elif QSEQ_DATA_TYPE == QSEQ_DATA_TAB3

#define qseq_card_large(S) ((S)->last_large - (S)->first_large)
#define qseq_card(S) ((S)->last - (S)->first)
#define qseq_nl(S,i) \
    ((S)->tind[(i)] >= 0 ? 1 : S->tab_large_nl[-(S)->tind[(i)]])
#define qseq_is_cell_zero(S, i)	((S)->tind[(i)] == 0)
/* only for large...! */
#define qseq_n(S, i) (S)->tab_large+(-(S)->tind[(i)])

extern void qseq_realloc_large(qseq_t Q, size_t sz);
extern void qseq_realloc_ind(qseq_t Q, size_t sz);

#endif

#if QSEQ_DATA_TYPE == QSEQ_DATA_TAB1 || QSEQ_DATA_TYPE == QSEQ_DATA_TAB2
#define qseq_copy_n(n, S, i) do { \
	MPN_COPY((n), qseq_n((S), (i)), qseq_nl((S), (i))); \
    } while(0)
#define qseq_set_n(S, i, a, an) do { \
	MPN_COPY(qseq_n((S), (i)), (a), (an)); \
    } while(0)	
#elif QSEQ_DATA_TYPE == QSEQ_DATA_TAB3
extern void qseq_copy_n(mp_ptr n, qseq_t Q, int i);
extern void qset_set_n(qseq_t Q, int i, mp_ptr a, mp_size_t an);
#endif

#define qseq_is_empty(S) (qseq_card((S)) == 0)

/* special trick! */
#if QSEQ_DATA_TYPE == QSEQ_DATA_TAB1
# if TRICK_FOR_ONE == 1
#  define qseq_is_cell_one(S, i) ((S)->tabq[(i)][0] == 0)
# else
#  define qseq_is_cell_one(S, i)      \
    (((S)->tabq[(i)][0] == 1) && ((S)->tabq[(i)][1] == 1))
# endif 
#elif QSEQ_DATA_TYPE == QSEQ_DATA_TAB2
# define qseq_is_cell_one(S, i) ((S)->tind[(i)+1] == (S)->tind[(i)])
#elif QSEQ_DATA_TYPE == QSEQ_DATA_TAB3
# define qseq_is_cell_one(S, i) ((S)->tind[(i)] == 1)
#else /* no sense for list? */
#endif

#define qseq_is_used(S) ((S)->alloc_ind != 0)

extern void qseq_init(qseq_t Q, mp_size_t sz);
extern void qseq_realloc(qseq_t Q, size_t sz);
extern void qseq_clear(qseq_t Q);
extern int qseq_is_equal(qseq_t Q, qseq_t R);
extern void qseq_print(qseq_t Q);
extern void qseq_print_cell(qseq_t Q, int i);
extern void qseq_dump(qseq_t Q);

extern void qseq_check(qseq_t Q, mp_ptr a, mp_size_t an, mp_ptr b, mp_size_t bn,mp_ptr ap, mp_size_t apn, mp_ptr bp, mp_size_t bpn);

extern void qseq_add_last(qseq_t Q, mpz_t x);
extern void qseq_add_last_one(qseq_t Q);
extern int qseq_determinant(qseq_t Q);
extern void qseq_remove_last(qseq_t Q);
extern void qseq_add_last_mpn(qseq_t Q, mp_ptr a, mp_size_t an);

extern void mpn_qseq_addmul_last(mp_ptr x, mp_size_t *xn, mp_ptr y, mp_size_t yn, qseq_t Q);
extern mp_ptr mpn_qseq_get_last(mp_size_t *tmpn, qseq_t Q);

#define qseq_add_last_ui(S, q) qseq_add_last_mpn((S), &(q), 1)

extern void qseq_init_matrix_set_q(struct hgcd_matrix *M, qseq_t Q, int i);
extern void qseq_mul_qi(struct hgcd_matrix *Q, qseq_t lq, int i, mp_ptr tp, mp_size_t tp_alloc);
extern void qseq_omul(qseq_t S, qseq_t T);
