/* only for lgbase = GMP_NUMB_BITS */
#define mpn_ty_size(a, an, lgbase) (an)

/* a = B^n => ||a||=n=ndig(a)-1=floor(||a||)=ceiling(||a||).
   B^(n-1) < a < B^n => n-1 < ||a|| < n, ndig(a)=n, 
   floor(||a||)=n-1; but ceiling(||a||) = n = ndig(a).
 */
#define mpn_gcd_floor_norm(a, an) ((an) == 0 ? 0 : (an)-1)
#define mpn_gcd_is_norm_ge(a, an, m) (mpn_gcd_floor_norm((a), (an)) >= (m))
extern int mpn_is_power_of_base(mp_ptr a, mp_size_t an);
extern int mpn_gcd_is_norm_le(mp_ptr a, mp_size_t an, mp_size_t m);
extern int mpn_gcd_is_norm_lt(mp_ptr a, mp_size_t an, mp_size_t m);
extern mp_size_t mpn_gcd_ceiling_norm(mp_ptr a, mp_size_t an);

int gcd_stopping_condition(mp_ptr b, mp_size_t bn, mp_size_t m, mp_ptr rmin, mp_size_t rminn, int use_eq, regular_t Q, int qeuclid);
int gcd_stopping_condition_ge(mp_ptr a, mp_size_t an, mp_size_t m, mp_ptr rmin, mp_size_t rminn);
mp_size_t euclidean_step(qseq_t Q, mp_ptr q, mp_ptr r, mp_ptr a, mp_size_t an, mp_ptr b, mp_size_t bn, mp_ptr tp, mp_size_t tp_alloc);

extern void euclid_gcd(regular_t R, mp_ptr a, mp_size_t an, mp_ptr b, mp_size_t bn, mp_size_t m, mp_ptr rmin, mp_size_t rminn, mp_ptr tp, mp_size_t tp_alloc, int qeuclid);

extern void euclid_step_back(regular_t R, mp_ptr a, mp_size_t *an, mp_ptr b, mp_size_t *bn, mp_ptr tp, mp_size_t tp_alloc);
extern mp_size_t euclid_gcd_backwards(regular_t Q, mp_ptr a, mp_size_t an, mp_ptr b, mp_size_t bn, mp_size_t m, mp_ptr emin, mp_size_t eminn, int imax);
