/*
 * Decompiled with CFR 0.152.
 */
package jMEF;

import jMEF.ExponentialFamily;
import jMEF.PVector;
import jMEF.Parameter;
import java.util.Random;

public final class UnivariateGaussianFixedVariance
extends ExponentialFamily<PVector, PVector> {
    private static final long serialVersionUID = 1L;
    private double variance;

    public UnivariateGaussianFixedVariance() {
        this.variance = 1.0;
    }

    public UnivariateGaussianFixedVariance(double variance) {
        this.variance = variance;
    }

    @Override
    public double F(PVector T) {
        return (T.array[0] * T.array[0] * this.variance + Math.log(Math.PI * 2 * this.variance)) / 2.0;
    }

    @Override
    public PVector gradF(PVector T) {
        PVector gradient = new PVector(1);
        gradient.array[0] = this.variance * T.array[0];
        gradient.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return gradient;
    }

    @Override
    public double G(PVector H) {
        return H.array[0] * H.array[0] / (2.0 * this.variance);
    }

    @Override
    public PVector gradG(PVector H) {
        PVector gradient = new PVector(1);
        gradient.array[0] = H.array[0] / this.variance;
        gradient.type = Parameter.TYPE.NATURAL_PARAMETER;
        return gradient;
    }

    @Override
    public PVector t(PVector x) {
        PVector t = new PVector(1);
        t.array[0] = x.array[0];
        t.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return t;
    }

    @Override
    public double k(PVector x) {
        return -(x.array[0] * x.array[0]) / (2.0 * this.variance);
    }

    @Override
    public PVector Lambda2Theta(PVector L) {
        PVector T = new PVector(1);
        T.array[0] = L.array[0] / this.variance;
        T.type = Parameter.TYPE.NATURAL_PARAMETER;
        return T;
    }

    @Override
    public PVector Theta2Lambda(PVector T) {
        PVector L = new PVector(1);
        L.array[0] = T.array[0] * this.variance;
        L.type = Parameter.TYPE.SOURCE_PARAMETER;
        return L;
    }

    @Override
    public PVector Lambda2Eta(PVector L) {
        PVector H = new PVector(1);
        H.array[0] = L.array[0];
        H.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return H;
    }

    @Override
    public PVector Eta2Lambda(PVector H) {
        PVector L = new PVector(1);
        L.array[0] = H.array[0];
        L.type = Parameter.TYPE.SOURCE_PARAMETER;
        return L;
    }

    @Override
    public double density(PVector x, PVector param) {
        if (param.type == Parameter.TYPE.SOURCE_PARAMETER) {
            return Math.exp(-((x.array[0] - param.array[0]) * (x.array[0] - param.array[0])) / (2.0 * this.variance)) / Math.sqrt(Math.PI * 2 * this.variance);
        }
        if (param.type == Parameter.TYPE.NATURAL_PARAMETER) {
            return super.density(x, param);
        }
        return super.density(x, this.Eta2Theta(param));
    }

    @Override
    public PVector drawRandomPoint(PVector L) {
        Random rand = new Random();
        PVector v = new PVector(1);
        v.array[0] = rand.nextGaussian() * Math.sqrt(this.variance);
        return v.Plus(L);
    }

    @Override
    public double KLD(PVector LP, PVector LQ) {
        double mP = LP.array[0];
        double mQ = LQ.array[0];
        return (mQ - mP) * (mQ - mP) / (2.0 * this.variance);
    }
}

