/*
 * Decompiled with CFR 0.152.
 */
package jMEF;

import jMEF.ExponentialFamily;
import jMEF.PVector;
import jMEF.Parameter;
import java.util.Random;

public final class UnivariateGaussian
extends ExponentialFamily<PVector, PVector> {
    private static final long serialVersionUID = 1L;

    @Override
    public double F(PVector T) {
        return -0.25 * T.array[0] * T.array[0] / T.array[1] + 0.5 * Math.log(-Math.PI / T.array[1]);
    }

    @Override
    public PVector gradF(PVector T) {
        PVector gradient = new PVector(2);
        gradient.array[0] = -0.5 * T.array[0] / T.array[1];
        gradient.array[1] = 0.25 * (T.array[0] * T.array[0]) / (T.array[1] * T.array[1]) - 0.5 / T.array[1];
        gradient.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return gradient;
    }

    @Override
    public double G(PVector H) {
        return -0.5 * Math.log(Math.abs(H.array[0] * H.array[0] - H.array[1]));
    }

    @Override
    public PVector gradG(PVector H) {
        PVector gradient = new PVector(2);
        double tmp = H.array[0] * H.array[0] - H.array[1];
        gradient.array[0] = -H.array[0] / tmp;
        gradient.array[1] = 0.5 / tmp;
        gradient.type = Parameter.TYPE.NATURAL_PARAMETER;
        return gradient;
    }

    @Override
    public PVector t(PVector x) {
        PVector t = new PVector(2);
        t.array[0] = x.array[0];
        t.array[1] = x.array[0] * x.array[0];
        t.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return t;
    }

    @Override
    public double k(PVector x) {
        return 0.0;
    }

    @Override
    public PVector Lambda2Theta(PVector L) {
        PVector T = new PVector(2);
        T.array[0] = L.array[0] / L.array[1];
        T.array[1] = -1.0 / (2.0 * L.array[1]);
        T.type = Parameter.TYPE.NATURAL_PARAMETER;
        return T;
    }

    @Override
    public PVector Theta2Lambda(PVector T) {
        PVector L = new PVector(2);
        L.array[0] = -T.array[0] / (2.0 * T.array[1]);
        L.array[1] = -1.0 / (2.0 * T.array[1]);
        L.type = Parameter.TYPE.SOURCE_PARAMETER;
        return L;
    }

    @Override
    public PVector Lambda2Eta(PVector L) {
        PVector H = new PVector(2);
        H.array[0] = L.array[0];
        H.array[1] = L.array[0] * L.array[0] + L.array[1];
        H.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return H;
    }

    @Override
    public PVector Eta2Lambda(PVector H) {
        PVector L = new PVector(2);
        L.array[0] = H.array[0];
        L.array[1] = H.array[1] - H.array[0] * H.array[0];
        L.type = Parameter.TYPE.SOURCE_PARAMETER;
        return L;
    }

    public static double Rand(double mu, double sigma) {
        return mu + sigma * Math.sqrt(-2.0 * Math.log(Math.random())) * Math.cos(Math.PI * 2 * Math.random());
    }

    public static double Rand() {
        return UnivariateGaussian.Rand(0.0, 1.0);
    }

    @Override
    public double density(PVector x, PVector param) {
        if (param.type == Parameter.TYPE.SOURCE_PARAMETER) {
            return Math.exp(-(x.array[0] - param.array[0]) * (x.array[0] - param.array[0]) / (2.0 * param.array[1])) / Math.sqrt(Math.PI * 2 * param.array[1]);
        }
        if (param.type == Parameter.TYPE.NATURAL_PARAMETER) {
            return super.density(x, param);
        }
        return super.density(x, this.Eta2Theta(param));
    }

    @Override
    public PVector drawRandomPoint(PVector L) {
        PVector mean = new PVector(1);
        PVector variance = new PVector(1);
        mean.array[0] = L.array[0];
        variance.array[0] = L.array[1];
        Random rand = new Random();
        PVector v = new PVector(1);
        v.array[0] = rand.nextGaussian() * Math.sqrt(variance.array[0]);
        return v.Plus(mean);
    }

    @Override
    public double KLD(PVector LP, PVector LQ) {
        double mP = LP.array[0];
        double vP = LP.array[1];
        double mQ = LQ.array[0];
        double vQ = LQ.array[1];
        return 0.5 * (2.0 * Math.log(Math.sqrt(vQ / vP)) + vP / vQ + (mQ - mP) * (mQ - mP) / vQ - 1.0);
    }
}

