/*
 * Decompiled with CFR 0.152.
 */
package jMEF;

import jMEF.ExponentialFamily;
import jMEF.PVector;
import jMEF.Parameter;

public final class Rayleigh
extends ExponentialFamily<PVector, PVector> {
    private static final long serialVersionUID = 1L;

    @Override
    public double F(PVector T) {
        return -Math.log(-2.0 * T.array[0]);
    }

    @Override
    public PVector gradF(PVector T) {
        PVector gradient = new PVector(1);
        gradient.array[0] = -1.0 / T.array[0];
        gradient.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return gradient;
    }

    @Override
    public double G(PVector H) {
        return -Math.log(H.array[0]);
    }

    @Override
    public PVector gradG(PVector H) {
        PVector gradient = new PVector(1);
        gradient.array[0] = -1.0 / H.array[0];
        gradient.type = Parameter.TYPE.NATURAL_PARAMETER;
        return gradient;
    }

    @Override
    public PVector t(PVector x) {
        PVector t = new PVector(1);
        t.array[0] = x.array[0] * x.array[0];
        t.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return t;
    }

    @Override
    public double k(PVector x) {
        return Math.log(x.array[0]);
    }

    @Override
    public PVector Lambda2Theta(PVector L) {
        PVector T = new PVector(1);
        T.array[0] = -1.0 / (2.0 * L.array[0]);
        T.type = Parameter.TYPE.NATURAL_PARAMETER;
        return T;
    }

    @Override
    public PVector Theta2Lambda(PVector T) {
        PVector L = new PVector(1);
        L.array[0] = -1.0 / (2.0 * T.array[0]);
        L.type = Parameter.TYPE.SOURCE_PARAMETER;
        return L;
    }

    @Override
    public PVector Lambda2Eta(PVector L) {
        PVector H = new PVector(1);
        H.array[0] = 2.0 * L.array[0];
        H.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return H;
    }

    @Override
    public PVector Eta2Lambda(PVector H) {
        PVector L = new PVector(1);
        L.array[0] = H.array[0] / 2.0;
        L.type = Parameter.TYPE.SOURCE_PARAMETER;
        return L;
    }

    @Override
    public double density(PVector x, PVector param) {
        if (param.type == Parameter.TYPE.SOURCE_PARAMETER) {
            return Math.exp(-(x.array[0] * x.array[0]) / (2.0 * param.array[0])) * x.array[0] / param.array[0];
        }
        if (param.type == Parameter.TYPE.NATURAL_PARAMETER) {
            return super.density(x, param);
        }
        return super.density(x, this.Eta2Theta(param));
    }

    @Override
    public PVector drawRandomPoint(PVector L) {
        PVector x = new PVector(1);
        x.array[0] = Math.sqrt(-2.0 * Math.log(Math.random()) * L.array[0]);
        return x;
    }

    @Override
    public double KLD(PVector LP, PVector LQ) {
        double vP = LP.array[0];
        double vQ = LQ.array[0];
        return Math.log(vQ / vP) + (vP - vQ) / vQ;
    }
}

