/*
 * Decompiled with CFR 0.152.
 */
package jMEF;

import jMEF.ExponentialFamily;
import jMEF.PVector;
import jMEF.Parameter;

public final class Poisson
extends ExponentialFamily<PVector, PVector> {
    private static final long serialVersionUID = 1L;

    @Override
    public double F(PVector T) {
        return Math.exp(T.array[0]);
    }

    @Override
    public PVector gradF(PVector T) {
        PVector g = new PVector(1);
        g.array[0] = Math.exp(T.array[0]);
        g.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return g;
    }

    @Override
    public double G(PVector H) {
        return H.array[0] * Math.log(H.array[0]) - H.array[0];
    }

    @Override
    public PVector gradG(PVector H) {
        PVector g = new PVector(1);
        g.array[0] = Math.log(H.array[0]);
        g.type = Parameter.TYPE.NATURAL_PARAMETER;
        return g;
    }

    @Override
    public PVector t(PVector x) {
        PVector t = new PVector(1);
        t.array[0] = x.array[0];
        t.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return t;
    }

    @Override
    public double k(PVector x) {
        return -Math.log(this.fact((int)x.array[0]));
    }

    @Override
    public PVector Lambda2Theta(PVector L) {
        PVector T = new PVector(1);
        T.array[0] = Math.log(L.array[0]);
        T.type = Parameter.TYPE.NATURAL_PARAMETER;
        return T;
    }

    @Override
    public PVector Theta2Lambda(PVector T) {
        PVector L = new PVector(1);
        L.array[0] = Math.exp(T.array[0]);
        L.type = Parameter.TYPE.SOURCE_PARAMETER;
        return L;
    }

    @Override
    public PVector Lambda2Eta(PVector L) {
        PVector H = new PVector(1);
        H.array[0] = L.array[0];
        H.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return H;
    }

    @Override
    public PVector Eta2Lambda(PVector H) {
        PVector L = new PVector(1);
        L.array[0] = H.array[0];
        L.type = Parameter.TYPE.SOURCE_PARAMETER;
        return L;
    }

    @Override
    public double density(PVector x, PVector param) {
        if (param.type == Parameter.TYPE.SOURCE_PARAMETER) {
            return Math.pow(param.array[0], x.array[0]) * Math.exp(-param.array[0]) / this.fact((int)x.array[0]);
        }
        if (param.type == Parameter.TYPE.NATURAL_PARAMETER) {
            return super.density(x, param);
        }
        return super.density(x, this.Eta2Theta(param));
    }

    private double fact(double n) {
        double f = 1.0;
        int i = 1;
        while ((double)i <= n) {
            f *= (double)i;
            ++i;
        }
        return f;
    }

    @Override
    public PVector drawRandomPoint(PVector L) {
        double l = Math.exp(-L.array[0]);
        double p = 1.0;
        int k = 0;
        do {
            ++k;
        } while ((p *= Math.random()) > l);
        PVector point = new PVector(1);
        point.array[0] = k - 1;
        return point;
    }

    @Override
    public double KLD(PVector LP, PVector LQ) {
        double lp = LP.array[0];
        double lq = LQ.array[0];
        return lq - lp * (1.0 + Math.log(lq / lp));
    }
}

