/*
 * Decompiled with CFR 0.152.
 */
package jMEF;

import jMEF.PMatrix;
import jMEF.PVector;
import jMEF.Parameter;

public final class PVectorMatrix
extends Parameter {
    private static final long serialVersionUID = 1L;
    public PVector v;
    public PMatrix M;
    public int dim;

    public PVectorMatrix(int dim) {
        this.dim = dim;
        this.v = new PVector(dim);
        this.M = new PMatrix(dim);
    }

    @Override
    public PVectorMatrix Plus(Parameter v2m2) {
        PVectorMatrix Q = (PVectorMatrix)v2m2;
        PVectorMatrix result = new PVectorMatrix(Q.v.dim);
        result.v = this.v.Plus(Q.v);
        result.M = this.M.Plus(Q.M);
        return result;
    }

    @Override
    public PVectorMatrix Minus(Parameter v2m2) {
        PVectorMatrix Q = (PVectorMatrix)v2m2;
        PVectorMatrix result = new PVectorMatrix(Q.v.dim);
        result.v = this.v.Minus(Q.v);
        result.M = this.M.Minus(Q.M);
        return result;
    }

    @Override
    public PVectorMatrix Times(double lambda) {
        PVectorMatrix result = new PVectorMatrix(this.v.dim);
        result.v = this.v.Times(lambda);
        result.M = this.M.Times(lambda);
        return result;
    }

    @Override
    public double InnerProduct(Parameter v2m2) {
        PVectorMatrix Q = (PVectorMatrix)v2m2;
        return this.v.InnerProduct(Q.v) + this.M.InnerProduct(Q.M);
    }

    public static PVectorMatrix RandomDistribution(int dim) {
        PVectorMatrix vM = new PVectorMatrix(dim);
        vM.v = PVector.Random(dim);
        vM.M = PMatrix.RandomPositiveDefinite(dim);
        return vM;
    }

    public static boolean equals(PVectorMatrix v1m1, PVectorMatrix v2m2) {
        return PVector.equals(v1m1.v, v2m2.v) && PMatrix.equals(v1m1.M, v2m2.M);
    }

    public String toString() {
        return this.v + "\n" + this.M + "\n";
    }

    @Override
    public Parameter clone() {
        PVectorMatrix param = new PVectorMatrix(this.dim);
        param.type = this.type;
        param.v = (PVector)this.v.clone();
        param.M = (PMatrix)this.M.clone();
        return param;
    }

    @Override
    public int getDimension() {
        return this.v.dim;
    }
}

