/*
 * Decompiled with CFR 0.152.
 */
package jMEF;

import jMEF.PMatrix;
import jMEF.Parameter;
import java.util.Arrays;
import java.util.Locale;

public final class PVector
extends Parameter {
    private static final long serialVersionUID = 1L;
    public int dim;
    public double[] array;

    public PVector(int dim) {
        this.dim = dim;
        this.array = new double[dim];
    }

    public PVector(double[] x) {
        this.dim = x.length;
        this.array = x;
    }

    @Override
    public PVector Plus(Parameter v2) {
        PVector result = new PVector(this.dim);
        PVector q = (PVector)v2;
        int i = 0;
        while (i < q.dim) {
            result.array[i] = this.array[i] + q.array[i];
            ++i;
        }
        return result;
    }

    @Override
    public PVector Minus(Parameter v2) {
        PVector result = new PVector(this.dim);
        PVector q = (PVector)v2;
        int i = 0;
        while (i < q.dim) {
            result.array[i] = this.array[i] - q.array[i];
            ++i;
        }
        return result;
    }

    @Override
    public PVector Times(double lambda) {
        PVector result = new PVector(this.dim);
        int i = 0;
        while (i < this.dim) {
            result.array[i] = this.array[i] * lambda;
            ++i;
        }
        return result;
    }

    @Override
    public double InnerProduct(Parameter v2) {
        double result = 0.0;
        PVector q = (PVector)v2;
        int i = 0;
        while (i < q.dim) {
            result += this.array[i] * q.array[i];
            ++i;
        }
        return result;
    }

    public PMatrix OuterProduct() {
        PMatrix result = new PMatrix(this.dim);
        int i = 0;
        while (i < this.dim) {
            int j = 0;
            while (j < this.dim) {
                result.array[i][j] = this.array[i] * this.array[j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static PVector Random(int dim) {
        PVector result = new PVector(dim);
        int i = 0;
        while (i < dim) {
            result.array[i] = Math.random();
            ++i;
        }
        return result;
    }

    public static double[][] Vector2Matrix(PVector[] v) {
        int n = v.length;
        int dim = v[1].dim;
        double[][] result = new double[n][dim];
        int i = 0;
        while (i < n) {
            result[i] = v[i].array;
            ++i;
        }
        return result;
    }

    public static PVector RandomDistribution(int dim) {
        PVector result = PVector.Random(dim);
        double cumul = 0.0;
        int i = 0;
        while (i < dim) {
            cumul += result.array[i];
            ++i;
        }
        i = 0;
        while (i < dim) {
            int n = i++;
            result.array[n] = result.array[n] / cumul;
        }
        return result;
    }

    public static boolean equals(PVector v1, PVector v2) {
        return Arrays.equals(v1.array, v2.array);
    }

    public void setArray(double[] x) {
        this.array = x;
    }

    public double norm2() {
        double norm = 0.0;
        int i = 0;
        while (i < this.array.length) {
            norm += this.array[i] * this.array[i];
            ++i;
        }
        return Math.sqrt(norm);
    }

    public String toString() {
        String output = "( ";
        int i = 0;
        while (i < this.dim) {
            output = String.valueOf(output) + String.format(Locale.ENGLISH, "%13.6f ", this.array[i]);
            ++i;
        }
        return String.valueOf(output) + ")";
    }

    @Override
    public Parameter clone() {
        PVector param = new PVector(this.dim);
        param.type = this.type;
        param.array = (double[])this.array.clone();
        return param;
    }

    @Override
    public int getDimension() {
        return this.dim;
    }
}

