/*
 * Decompiled with CFR 0.152.
 */
package jMEF;

import jMEF.PVector;
import jMEF.Parameter;
import java.util.Arrays;
import java.util.Locale;

public class PMatrix
extends Parameter {
    private static final long serialVersionUID = 1L;
    public int dim;
    public double[][] array;

    public PMatrix(int dim) {
        this.dim = dim;
        this.array = new double[dim][dim];
    }

    public PMatrix(PMatrix M) {
        this.dim = M.dim;
        this.array = new double[this.dim][this.dim];
        int i = 0;
        while (i < this.dim) {
            int j = 0;
            while (j < this.dim) {
                this.array[i][j] = M.array[i][j];
                ++j;
            }
            ++i;
        }
    }

    @Override
    public PMatrix Plus(Parameter m2) {
        PMatrix Q = (PMatrix)m2;
        PMatrix result = new PMatrix(this.dim);
        int i = 0;
        while (i < this.dim) {
            int j = 0;
            while (j < this.dim) {
                result.array[i][j] = this.array[i][j] + Q.array[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    public PMatrix Minus(Parameter m2) {
        PMatrix Q = (PMatrix)m2;
        PMatrix result = new PMatrix(this.dim);
        int i = 0;
        while (i < this.dim) {
            int j = 0;
            while (j < this.dim) {
                result.array[i][j] = this.array[i][j] - Q.array[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    public PMatrix Times(double lambda) {
        PMatrix result = new PMatrix(this.dim);
        int i = 0;
        while (i < this.dim) {
            int j = 0;
            while (j < this.dim) {
                result.array[i][j] = this.array[i][j] * lambda;
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    public double InnerProduct(Parameter m2) {
        PMatrix Q = (PMatrix)m2;
        return this.Multiply(Q.Transpose()).Trace();
    }

    public PMatrix Multiply(PMatrix m2) {
        PMatrix result = new PMatrix(this.dim);
        int i = 0;
        while (i < this.dim) {
            int j = 0;
            while (j < this.dim) {
                double sum = 0.0;
                int k = 0;
                while (k < this.dim) {
                    sum += this.array[i][k] * m2.array[k][j];
                    ++k;
                }
                result.array[i][j] = sum;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public PVector MultiplyVectorRight(PVector v) {
        PVector result = new PVector(v.dim);
        int i = 0;
        while (i < this.dim) {
            double sum = 0.0;
            int j = 0;
            while (j < this.dim) {
                sum += this.array[i][j] * v.array[j];
                ++j;
            }
            result.array[i] = sum;
            ++i;
        }
        return result;
    }

    public PMatrix Inverse() {
        PMatrix result = new PMatrix(this);
        PMatrix.GaussJordan(result.array, this.dim);
        return result;
    }

    private static void GaussJordan(double[][] a, int dim) {
        double save;
        int j;
        int i;
        double det = 1.0;
        int[] ik = new int[dim];
        int[] jk = new int[dim];
        int k = 0;
        while (k < dim) {
            double big = 0.0;
            i = k;
            while (i < dim) {
                j = k;
                while (j < dim) {
                    if (Math.abs(big) <= Math.abs(a[i][j])) {
                        big = a[i][j];
                        ik[k] = i;
                        jk[k] = j;
                    }
                    ++j;
                }
                ++i;
            }
            i = ik[k];
            if (i > k) {
                j = 0;
                while (j < dim) {
                    save = a[k][j];
                    a[k][j] = a[i][j];
                    a[i][j] = -save;
                    ++j;
                }
            }
            if ((j = jk[k]) > k) {
                i = 0;
                while (i < dim) {
                    save = a[i][k];
                    a[i][k] = a[i][j];
                    a[i][j] = -save;
                    ++i;
                }
            }
            i = 0;
            while (i < dim) {
                if (i != k) {
                    a[i][k] = -a[i][k] / big;
                }
                ++i;
            }
            i = 0;
            while (i < dim) {
                j = 0;
                while (j < dim) {
                    if (i != k && j != k) {
                        double[] dArray = a[i];
                        int n = j;
                        dArray[n] = dArray[n] + a[i][k] * a[k][j];
                    }
                    ++j;
                }
                ++i;
            }
            j = 0;
            while (j < dim) {
                if (j != k) {
                    double[] dArray = a[k];
                    int n = j;
                    dArray[n] = dArray[n] / big;
                }
                ++j;
            }
            a[k][k] = 1.0 / big;
            det *= big;
            ++k;
        }
        int L = 0;
        while (L < dim) {
            k = dim - L - 1;
            j = ik[k];
            if (j > k) {
                i = 0;
                while (i < dim) {
                    save = a[i][k];
                    a[i][k] = -a[i][j];
                    a[i][j] = save;
                    ++i;
                }
            }
            if ((i = jk[k]) > k) {
                j = 0;
                while (j < dim) {
                    save = a[k][j];
                    a[k][j] = -a[i][j];
                    a[i][j] = save;
                    ++j;
                }
            }
            ++L;
        }
    }

    public PMatrix Transpose() {
        PMatrix T = new PMatrix(this.dim);
        int i = 0;
        while (i < this.dim) {
            int j = 0;
            while (j < this.dim) {
                T.array[i][j] = this.array[j][i];
                ++j;
            }
            ++i;
        }
        return T;
    }

    public double Determinant() {
        double result = 0.0;
        if (this.dim == 1) {
            return this.array[0][0];
        }
        PMatrix SubMatrix = new PMatrix(this.dim - 1);
        int i = 0;
        while (i < this.dim) {
            int j = 1;
            while (j < this.dim) {
                int k = 0;
                while (k < this.dim) {
                    if (k < i) {
                        SubMatrix.array[j - 1][k] = this.array[j][k];
                    } else if (k > i) {
                        SubMatrix.array[j - 1][k - 1] = this.array[j][k];
                    }
                    ++k;
                }
                ++j;
            }
            result += this.array[0][i] * Math.pow(-1.0, i) * SubMatrix.Determinant();
            ++i;
        }
        return result;
    }

    public double Trace() {
        double tr = 0.0;
        int i = 0;
        while (i < this.dim) {
            tr += this.array[i][i];
            ++i;
        }
        return tr;
    }

    public static PMatrix Random(int dim) {
        PMatrix m = new PMatrix(dim);
        int i = 0;
        while (i < dim) {
            int j = 0;
            while (j < dim) {
                m.array[i][j] = Math.random();
                ++j;
            }
            ++i;
        }
        return m;
    }

    public static PMatrix RandomPositiveDefinite(int dim) {
        PMatrix L = new PMatrix(dim);
        int i = 0;
        while (i < dim) {
            int j = 0;
            while (j < dim) {
                L.array[i][j] = j >= i ? Math.random() : 0.0;
                ++j;
            }
            ++i;
        }
        return L.Multiply(L.Transpose());
    }

    public PMatrix Cholesky() {
        PMatrix L = new PMatrix(this.dim);
        int i = 0;
        while (i < this.dim) {
            int j = 0;
            while (j <= i) {
                double sum = 0.0;
                int k = 0;
                while (k < j) {
                    sum += L.array[i][k] * L.array[j][k];
                    ++k;
                }
                if (i == j) {
                    L.array[i][i] = Math.sqrt(this.array[i][i] - sum);
                } else {
                    L.array[i][j] = (this.array[i][j] - sum) / L.array[j][j];
                }
                ++j;
            }
            if (L.array[i][i] <= 0.0) {
                throw new RuntimeException("MEF|Matrix is not positive definite!");
            }
            ++i;
        }
        return L;
    }

    public static boolean equals(PMatrix m1, PMatrix m2) {
        int i = 0;
        while (i < m1.dim) {
            if (!Arrays.equals(m1.array[i], m2.array[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        String output = "";
        int i = 0;
        while (i < this.dim) {
            output = String.valueOf(output) + "| ";
            int j = 0;
            while (j < this.dim) {
                output = String.valueOf(output) + String.format(Locale.ENGLISH, "%13.6f ", this.array[i][j]);
                ++j;
            }
            output = String.valueOf(output) + "|\n";
            ++i;
        }
        return output;
    }

    @Override
    public Parameter clone() {
        PMatrix param = new PMatrix(this.dim);
        param.type = this.type;
        param.array = (double[][])this.array.clone();
        return param;
    }

    @Override
    public int getDimension() {
        return this.dim;
    }
}

