/*
 * Decompiled with CFR 0.152.
 */
package jMEF;

import jMEF.ExponentialFamily;
import jMEF.PVector;
import jMEF.Parameter;
import java.util.Random;

public final class MultivariateIsotropicGaussian
extends ExponentialFamily<PVector, PVector> {
    private static final long serialVersionUID = 1L;

    @Override
    public double F(PVector T) {
        return 0.5 * (T.InnerProduct(T) + (double)T.dim * Math.log(Math.PI * 2));
    }

    @Override
    public PVector gradF(PVector T) {
        PVector gradient = (PVector)T.clone();
        gradient.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return gradient;
    }

    @Override
    public double G(PVector H) {
        return 0.5 * (H.InnerProduct(H) + (double)H.dim * Math.log(Math.PI * 2));
    }

    @Override
    public PVector gradG(PVector H) {
        PVector gradient = (PVector)H.clone();
        gradient.type = Parameter.TYPE.NATURAL_PARAMETER;
        return gradient;
    }

    @Override
    public PVector t(PVector x) {
        PVector t = (PVector)x.clone();
        t.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return t;
    }

    @Override
    public double k(PVector x) {
        return -0.5 * x.InnerProduct(x);
    }

    @Override
    public PVector Lambda2Theta(PVector L) {
        PVector T = (PVector)L.clone();
        T.type = Parameter.TYPE.NATURAL_PARAMETER;
        return T;
    }

    @Override
    public PVector Theta2Lambda(PVector T) {
        PVector L = (PVector)T.clone();
        L.type = Parameter.TYPE.SOURCE_PARAMETER;
        return L;
    }

    @Override
    public PVector Lambda2Eta(PVector L) {
        PVector H = (PVector)L.clone();
        H.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return H;
    }

    @Override
    public PVector Eta2Lambda(PVector H) {
        PVector L = (PVector)H.clone();
        L.type = Parameter.TYPE.SOURCE_PARAMETER;
        return L;
    }

    @Override
    public double density(PVector x, PVector param) {
        if (param.type == Parameter.TYPE.SOURCE_PARAMETER) {
            double v1 = x.Minus(param).InnerProduct(x.Minus(param));
            double v2 = Math.exp(-0.5 * v1);
            return v2 / Math.pow(Math.PI * 2, (double)x.dim / 2.0);
        }
        if (param.type == Parameter.TYPE.NATURAL_PARAMETER) {
            return super.density(x, param);
        }
        return super.density(x, this.Eta2Theta(param));
    }

    @Override
    public PVector drawRandomPoint(PVector L) {
        Random rand = new Random();
        PVector x = new PVector(L.getDimension());
        int i = 0;
        while (i < L.getDimension()) {
            x.array[i] = L.array[i] + rand.nextGaussian();
            ++i;
        }
        return x;
    }

    @Override
    public double KLD(PVector LP, PVector LQ) {
        PVector diff = LQ.Minus(LP);
        return 0.5 * diff.InnerProduct(diff);
    }
}

