/*
 * Decompiled with CFR 0.152.
 */
package jMEF;

import jMEF.ExponentialFamily;
import jMEF.PMatrix;
import jMEF.PVector;
import jMEF.PVectorMatrix;
import jMEF.Parameter;
import java.util.Random;

public final class MultivariateGaussian
extends ExponentialFamily<PVector, PVectorMatrix> {
    private static final long serialVersionUID = 1L;

    @Override
    public double F(PVectorMatrix T) {
        return 0.25 * T.M.Inverse().Multiply(T.v.OuterProduct()).Trace() - 0.5 * Math.log(T.M.Determinant()) + 0.5 * (double)T.v.dim * Math.log(Math.PI);
    }

    @Override
    public PVectorMatrix gradF(PVectorMatrix T) {
        PVectorMatrix gradient = new PVectorMatrix(T.v.dim);
        gradient.v = T.M.Inverse().MultiplyVectorRight(T.v).Times(0.5);
        gradient.M = T.M.Inverse().Times(-0.5).Minus(T.M.Inverse().MultiplyVectorRight(T.v).OuterProduct().Times(0.25));
        gradient.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return gradient;
    }

    @Override
    public double G(PVectorMatrix H) {
        return -0.5 * Math.log(1.0 + H.v.InnerProduct(H.M.Inverse().MultiplyVectorRight(H.v))) - 0.5 * Math.log(H.M.Times(-1.0).Determinant()) - (double)H.v.dim * 0.5 * Math.log(17.079468445347132);
    }

    @Override
    public PVectorMatrix gradG(PVectorMatrix H) {
        PVectorMatrix gradient = new PVectorMatrix(H.v.dim);
        PMatrix tmp = H.M.Plus(H.v.OuterProduct()).Inverse();
        gradient.v = tmp.MultiplyVectorRight(H.v).Times(-1.0);
        gradient.M = tmp.Times(-0.5);
        gradient.type = Parameter.TYPE.NATURAL_PARAMETER;
        return gradient;
    }

    @Override
    public PVectorMatrix t(PVector x) {
        PVectorMatrix t = new PVectorMatrix(x.dim);
        t.v = x;
        t.M = x.OuterProduct().Times(-1.0);
        t.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return t;
    }

    @Override
    public double k(PVector x) {
        return 0.0;
    }

    @Override
    public PVectorMatrix Lambda2Theta(PVectorMatrix L) {
        PVectorMatrix T = new PVectorMatrix(L.v.dim);
        PMatrix tmp = L.M.Inverse();
        T.v = tmp.MultiplyVectorRight(L.v);
        T.M = tmp.Times(0.5);
        T.type = Parameter.TYPE.NATURAL_PARAMETER;
        return T;
    }

    @Override
    public PVectorMatrix Theta2Lambda(PVectorMatrix T) {
        PVectorMatrix L = new PVectorMatrix(T.v.dim);
        L.M = T.M.Inverse().Times(0.5);
        L.v = L.M.MultiplyVectorRight(T.v);
        L.type = Parameter.TYPE.SOURCE_PARAMETER;
        return L;
    }

    @Override
    public PVectorMatrix Lambda2Eta(PVectorMatrix L) {
        PVectorMatrix H = new PVectorMatrix(L.v.dim);
        H.v = (PVector)L.v.clone();
        H.M = L.M.Plus(L.v.OuterProduct()).Times(-1.0);
        H.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return H;
    }

    @Override
    public PVectorMatrix Eta2Lambda(PVectorMatrix H) {
        PVectorMatrix L = new PVectorMatrix(H.v.dim);
        L.v = (PVector)H.v.clone();
        L.M = H.M.Plus(H.v.OuterProduct()).Times(-1.0);
        L.type = Parameter.TYPE.SOURCE_PARAMETER;
        return L;
    }

    @Override
    public double density(PVector x, PVectorMatrix param) {
        if (param.type == Parameter.TYPE.SOURCE_PARAMETER) {
            double v1 = x.Minus(param.v).InnerProduct(param.M.Inverse().MultiplyVectorRight(x.Minus(param.v)));
            double v2 = Math.exp(-0.5 * v1);
            double v3 = Math.pow(Math.PI * 2, (double)x.dim / 2.0) * Math.sqrt(param.M.Determinant());
            return v2 / v3;
        }
        if (param.type == Parameter.TYPE.NATURAL_PARAMETER) {
            return super.density(x, param);
        }
        return super.density(x, this.Eta2Theta(param));
    }

    @Override
    public PVector drawRandomPoint(PVectorMatrix L) {
        Random rand = new Random();
        PVector z = new PVector(L.getDimension());
        int i = 0;
        while (i < L.getDimension()) {
            z.array[i] = rand.nextGaussian();
            ++i;
        }
        return L.M.Cholesky().MultiplyVectorRight(z).Plus(L.v);
    }

    @Override
    public double KLD(PVectorMatrix LP, PVectorMatrix LQ) {
        PVector mP = LP.v;
        PMatrix vP = LP.M;
        PVector mQ = LQ.v;
        PMatrix vQ = LQ.M;
        PVector tmp = mQ.Minus(mP);
        return 0.5 * (Math.log(vQ.Determinant() / vP.Determinant()) + vQ.Inverse().Multiply(vP).Trace() + tmp.InnerProduct(vQ.Inverse().MultiplyVectorRight(tmp)) - (double)LP.dim);
    }
}

