/*
 * Decompiled with CFR 0.152.
 */
package jMEF;

import jMEF.ExponentialFamily;
import jMEF.PVector;
import jMEF.Parameter;

public final class MultinomialFixedN
extends ExponentialFamily<PVector, PVector> {
    private static final long serialVersionUID = 1L;
    private int n;

    public MultinomialFixedN() {
        this.n = 100;
    }

    public MultinomialFixedN(int n) {
        this.n = n;
    }

    @Override
    public double F(PVector T) {
        double sum = 0.0;
        int i = 0;
        while (i < T.getDimension()) {
            sum += Math.exp(T.array[i]);
            ++i;
        }
        return (double)this.n * Math.log(1.0 + sum) - Math.log(this.fact(this.n));
    }

    @Override
    public PVector gradF(PVector T) {
        double sum = 0.0;
        int i = 0;
        while (i < T.getDimension()) {
            sum += Math.exp(T.array[i]);
            ++i;
        }
        PVector gradient = new PVector(T.getDimension());
        gradient.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        int i2 = 0;
        while (i2 < T.getDimension()) {
            gradient.array[i2] = (double)this.n * Math.exp(T.array[i2]) / (1.0 + sum);
            ++i2;
        }
        return gradient;
    }

    @Override
    public double G(PVector H) {
        double sum1 = 0.0;
        double sum2 = 0.0;
        int i = 0;
        while (i < H.getDimension()) {
            sum1 += H.array[i] * Math.log(H.array[i]);
            sum2 += H.array[i];
            ++i;
        }
        return sum1 + ((double)this.n - sum2) * Math.log((double)this.n - sum2);
    }

    @Override
    public PVector gradG(PVector H) {
        double sum = 0.0;
        int i = 0;
        while (i < H.getDimension()) {
            sum += H.array[i];
            ++i;
        }
        PVector gradient = new PVector(H.getDimension());
        gradient.type = Parameter.TYPE.NATURAL_PARAMETER;
        int i2 = 0;
        while (i2 < H.getDimension()) {
            gradient.array[i2] = Math.log(H.array[i2] / ((double)this.n - sum));
            ++i2;
        }
        return gradient;
    }

    @Override
    public PVector t(PVector x) {
        PVector t = new PVector(x.getDimension() - 1);
        t.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        int i = 0;
        while (i < x.getDimension() - 1) {
            t.array[i] = x.array[i];
            ++i;
        }
        return t;
    }

    @Override
    public double k(PVector x) {
        double sum = 0.0;
        int i = 0;
        while (i < x.getDimension()) {
            sum -= Math.log(this.fact(x.array[i]));
            ++i;
        }
        return sum;
    }

    @Override
    public PVector Lambda2Theta(PVector L) {
        PVector theta = new PVector(L.getDimension() - 1);
        theta.type = Parameter.TYPE.NATURAL_PARAMETER;
        int i = 0;
        while (i < L.getDimension() - 1) {
            theta.array[i] = Math.log(L.array[i] / L.array[L.getDimension() - 1]);
            ++i;
        }
        return theta;
    }

    @Override
    public PVector Theta2Lambda(PVector T) {
        double sum = 0.0;
        int i = 0;
        while (i < T.getDimension()) {
            sum += Math.exp(T.array[i]);
            ++i;
        }
        PVector lambda = new PVector(T.getDimension() + 1);
        lambda.type = Parameter.TYPE.SOURCE_PARAMETER;
        int i2 = 0;
        while (i2 < T.getDimension()) {
            lambda.array[i2] = Math.exp(T.array[i2]) / (1.0 + sum);
            ++i2;
        }
        lambda.array[T.getDimension()] = 1.0 / (1.0 + sum);
        return lambda;
    }

    @Override
    public PVector Lambda2Eta(PVector L) {
        PVector H = new PVector(L.getDimension() - 1);
        H.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        int i = 0;
        while (i < L.getDimension() - 1) {
            H.array[i] = (double)this.n * L.array[i];
            ++i;
        }
        return H;
    }

    @Override
    public PVector Eta2Lambda(PVector H) {
        PVector L = new PVector(H.getDimension() + 1);
        L.type = Parameter.TYPE.SOURCE_PARAMETER;
        double sum = 0.0;
        int i = 0;
        while (i < H.getDimension()) {
            L.array[i] = H.array[i] / (double)this.n;
            sum += H.array[i];
            ++i;
        }
        L.array[H.getDimension()] = ((double)this.n - sum) / (double)this.n;
        return L;
    }

    @Override
    public double density(PVector x, PVector param) {
        if (param.type == Parameter.TYPE.SOURCE_PARAMETER) {
            double prod1 = 1.0;
            double prod2 = 1.0;
            int i = 0;
            while (i < param.getDimension()) {
                prod1 *= this.fact(x.array[i]);
                prod2 *= Math.pow(param.array[i], x.array[i]);
                ++i;
            }
            return this.fact(this.n) * prod2 / prod1;
        }
        if (param.type == Parameter.TYPE.NATURAL_PARAMETER) {
            return super.density(x, param);
        }
        return super.density(x, this.Eta2Theta(param));
    }

    private double fact(double n) {
        double f = 1.0;
        int i = 1;
        while ((double)i <= n) {
            f *= (double)i;
            ++i;
        }
        return f;
    }

    @Override
    public PVector drawRandomPoint(PVector L) {
        int k = L.dim;
        double[] p = new double[k];
        p[0] = L.array[0];
        int i = 1;
        while (i < k - 1) {
            p[i] = p[i - 1] + L.array[i];
            ++i;
        }
        p[k - 1] = 1.0;
        PVector x = new PVector(k);
        int i2 = 0;
        while (i2 < this.n) {
            double u = Math.random();
            int idx = 0;
            while (u > p[idx]) {
                ++idx;
            }
            int n = idx;
            x.array[n] = x.array[n] + 1.0;
            ++i2;
        }
        return x;
    }

    @Override
    public double KLD(PVector LA, PVector LB) {
        int k = LA.getDimension() - 1;
        double sum = 0.0;
        int i = 0;
        while (i < k) {
            sum += LA.array[i] * Math.log(LB.array[i] / LA.array[i]);
            ++i;
        }
        return (double)this.n * LA.array[k] * Math.log(LA.array[k] / LB.array[k]) - (double)this.n * sum;
    }
}

