/*
 * Decompiled with CFR 0.152.
 */
package jMEF;

import jMEF.ExponentialFamily;
import jMEF.PVector;
import jMEF.Parameter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Random;

public class MixtureModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    public ExponentialFamily EF = null;
    public int size;
    public double[] weight;
    public Parameter[] param;

    public MixtureModel(int n) {
        this.size = n;
        this.weight = new double[n];
        this.param = new Parameter[n];
    }

    public double density(Parameter x) {
        double cumul = 0.0;
        int i = 0;
        while (i < this.size) {
            cumul += this.weight[i] * this.EF.density(x, this.param[i]);
            ++i;
        }
        return cumul;
    }

    public PVector densityMatrix(double[][] x) {
        int n = x.length;
        PVector values = new PVector(n);
        PVector v = new PVector(x[0].length);
        int j = 0;
        while (j < n) {
            v.setArray(x[j]);
            double cumul = 0.0;
            int i = 0;
            while (i < this.size) {
                cumul += this.weight[i] * this.EF.density(v, this.param[i]);
                ++i;
            }
            values.array[j] = cumul;
            ++j;
        }
        return values;
    }

    public static void save(MixtureModel mm, String fileName) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            try {
                oos.writeObject(mm);
                oos.flush();
            }
            finally {
                try {
                    oos.close();
                }
                finally {
                    fos.close();
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static MixtureModel load(String fileName) {
        MixtureModel mm = null;
        try {
            FileInputStream fis = new FileInputStream(fileName);
            ObjectInputStream ois = new ObjectInputStream(fis);
            try {
                mm = (MixtureModel)ois.readObject();
            }
            finally {
                try {
                    ois.close();
                }
                finally {
                    fis.close();
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return mm;
    }

    public void normalizeWeights() {
        double sum = 0.0;
        int i = 0;
        while (i < this.size) {
            sum += this.weight[i];
            ++i;
        }
        i = 0;
        while (i < this.size) {
            int n = i++;
            this.weight[n] = this.weight[n] / sum;
        }
    }

    public String toString() {
        String output = String.format("Mixture containing %d elements\n\n", this.size);
        int i = 0;
        while (i < this.size) {
            output = String.valueOf(output) + String.format("Element %4d\n", i);
            output = String.valueOf(output) + String.format("Weight:\n %8.6f\n", this.weight[i]);
            output = String.valueOf(output) + String.format("Parameters:\n %s\n\n", this.param[i]);
            ++i;
        }
        return output;
    }

    public MixtureModel getRandomSubMixtureModel(int m) {
        Random rand = new Random();
        int n = this.size;
        int[] tab = new int[n];
        if (m < n) {
            MixtureModel g = new MixtureModel(m);
            g.EF = this.EF;
            int i = 0;
            while (i < m) {
                int ind;
                while (tab[ind = rand.nextInt(n)] != 0) {
                }
                g.param[i] = this.param[ind].clone();
                g.weight[i] = 1.0 / (double)m;
                tab[ind] = 1;
                ++i;
            }
            g.normalizeWeights();
            return g;
        }
        if (m == n) {
            return this;
        }
        return null;
    }

    public MixtureModel clone() {
        MixtureModel mm = new MixtureModel(this.size);
        mm.EF = this.EF;
        mm.weight = (double[])this.weight.clone();
        int i = 0;
        while (i < this.size) {
            mm.param[i] = this.param[i].clone();
            ++i;
        }
        return mm;
    }

    public int getDimension() {
        return this.param[0].getDimension();
    }

    public PVector[] drawRandomPoints(int m) {
        PVector[] points = new PVector[m];
        int n = this.size;
        double[] t = new double[n];
        double sum = 0.0;
        int i = 0;
        while (i < n) {
            t[i] = sum += this.weight[i];
            ++i;
        }
        i = 0;
        while (i < m) {
            double r = Math.random();
            int idx = 0;
            while (t[idx] < r && idx < n - 1) {
                ++idx;
            }
            points[i] = (PVector)this.EF.drawRandomPoint(this.param[idx]);
            ++i;
        }
        return points;
    }

    public static double KLDMC(MixtureModel f, MixtureModel g, int n) {
        PVector[] points = f.drawRandomPoints(n);
        return MixtureModel.KLDMC(f, g, points);
    }

    public static double KLDMC(MixtureModel f, MixtureModel g, PVector[] points) {
        double eps = 1.0E-99;
        double kld = 0.0;
        int i = 0;
        while (i < points.length) {
            kld += Math.log(Math.max(f.density(points[i]), eps) / Math.max(g.density(points[i]), eps));
            ++i;
        }
        return kld / (double)points.length;
    }
}

