/*
 * Decompiled with CFR 0.152.
 */
package jMEF;

import jMEF.ExponentialFamily;
import jMEF.PVector;
import jMEF.Parameter;

public class Laplacian
extends ExponentialFamily<PVector, PVector> {
    private static final long serialVersionUID = 1L;

    @Override
    public double F(PVector T) {
        return Math.log(-2.0 / T.array[0]);
    }

    @Override
    public PVector gradF(PVector T) {
        PVector g = new PVector(T.dim);
        g.array[0] = -1.0 / T.array[0];
        g.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return g;
    }

    @Override
    public double G(PVector H) {
        return -Math.log(H.array[0]);
    }

    @Override
    public PVector gradG(PVector H) {
        PVector g = new PVector(1);
        g.array[0] = -1.0 / H.array[0];
        g.type = Parameter.TYPE.NATURAL_PARAMETER;
        return g;
    }

    @Override
    public PVector t(PVector x) {
        PVector t = new PVector(1);
        t.array[0] = Math.abs(x.array[0]);
        t.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return t;
    }

    @Override
    public double k(PVector x) {
        return 0.0;
    }

    @Override
    public PVector Lambda2Theta(PVector L) {
        PVector T = new PVector(L.dim);
        T.array[0] = -1.0 / L.array[0];
        T.type = Parameter.TYPE.NATURAL_PARAMETER;
        return T;
    }

    @Override
    public PVector Theta2Lambda(PVector T) {
        PVector L = new PVector(T.dim);
        L.array[0] = -1.0 / T.array[0];
        L.type = Parameter.TYPE.SOURCE_PARAMETER;
        return L;
    }

    @Override
    public PVector Lambda2Eta(PVector L) {
        PVector H = new PVector(1);
        H.array[0] = L.array[0];
        H.type = Parameter.TYPE.EXPECTATION_PARAMETER;
        return H;
    }

    @Override
    public PVector Eta2Lambda(PVector H) {
        PVector L = new PVector(1);
        L.array[0] = H.array[0];
        L.type = Parameter.TYPE.SOURCE_PARAMETER;
        return L;
    }

    @Override
    public double density(PVector x, PVector param) {
        if (param.type == Parameter.TYPE.SOURCE_PARAMETER) {
            return 1.0 / (2.0 * param.array[0]) * Math.exp(-Math.abs(x.array[0]) / param.array[0]);
        }
        if (param.type == Parameter.TYPE.NATURAL_PARAMETER) {
            return super.density(x, param);
        }
        return super.density(x, this.Eta2Theta(param));
    }

    @Override
    public PVector drawRandomPoint(PVector L) {
        double u = Math.random() - 0.5;
        PVector point = new PVector(1);
        point.array[0] = -L.array[0] * Math.signum(u) * Math.log(1.0 - 2.0 * Math.abs(u));
        return point;
    }

    @Override
    public double KLD(PVector LP, PVector LQ) {
        double sP = LP.array[0];
        double sQ = LQ.array[0];
        return Math.log(sQ / sP) + (sP - sQ) / sQ;
    }
}

