/*
 * Decompiled with CFR 0.152.
 */
package jMEF;

import jMEF.Clustering;
import jMEF.ExponentialFamily;
import jMEF.MixtureModel;
import jMEF.PVector;
import jMEF.Parameter;

public class HierarchicalMixtureModel {
    public ExponentialFamily EF = null;
    public double weight = 0.0;
    public MixtureModel node = null;
    public HierarchicalMixtureModel parent = null;
    public HierarchicalMixtureModel leftChild = null;
    public HierarchicalMixtureModel rightChild = null;
    public Clustering.CLUSTERING_TYPE type = Clustering.CLUSTERING_TYPE.SYMMETRIC;
    public int resolutionMax;

    public MixtureModel getResolution(int resolution) {
        if (resolution == 1 || this.leftChild == null && this.rightChild == null) {
            MixtureModel mix = new MixtureModel(1);
            mix.EF = this.EF;
            mix.weight[0] = this.weight;
            mix.param[0] = Clustering.getCentroid(this.node, this.type);
            return HierarchicalMixtureModel.mixtureT2L(mix);
        }
        int n1 = 0;
        int n2 = 0;
        double w1 = 0.0;
        double w2 = 0.0;
        MixtureModel mm1 = null;
        MixtureModel mm2 = null;
        if (this.leftChild != null) {
            mm1 = this.leftChild.getResolution(resolution - 1);
            n1 = mm1.size;
            w1 = this.leftChild.weight;
        }
        if (this.rightChild != null) {
            mm2 = this.rightChild.getResolution(resolution - 1);
            n2 = mm2.size;
            w2 = this.rightChild.weight;
        }
        MixtureModel mix = new MixtureModel(n1 + n2);
        mix.EF = this.EF;
        int i = 0;
        while (i < n1) {
            mix.param[i] = mm1.param[i];
            mix.weight[i] = w1 * mm1.weight[i];
            ++i;
        }
        i = 0;
        while (i < n2) {
            mix.param[n1 + i] = mm2.param[i];
            mix.weight[n1 + i] = w2 * mm2.weight[i];
            ++i;
        }
        mix.normalizeWeights();
        return mix;
    }

    public MixtureModel getOptimalMixtureModel(double t) {
        return this.getOptimalMixtureModel(t, 5000);
    }

    public MixtureModel getOptimalMixtureModel(double t, int n) {
        MixtureModel mm_init = this.getResolution(this.resolutionMax);
        MixtureModel mm_opt = mm_init.clone();
        int idx_1 = 1;
        int idx_2 = this.resolutionMax;
        PVector[] points = mm_init.drawRandomPoints(n);
        while (idx_1 < idx_2 - 1) {
            int idx = (idx_1 + idx_2) / 2;
            MixtureModel mm = this.getResolution(idx);
            double kld = MixtureModel.KLDMC(mm_init, mm, points);
            if (kld < t) {
                idx_2 = idx;
                mm_opt = mm;
                continue;
            }
            idx_1 = idx;
        }
        return mm_opt;
    }

    private static MixtureModel mixtureT2L(MixtureModel fT) {
        int size = fT.size;
        MixtureModel fL = new MixtureModel(size);
        fL.EF = fT.EF;
        int i = 0;
        while (i < size) {
            fL.weight[i] = fT.weight[i];
            fL.param[i] = fT.EF.Theta2Lambda(fT.param[i]);
            fL.param[i].type = Parameter.TYPE.SOURCE_PARAMETER;
            ++i;
        }
        return fL;
    }
}

